/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import berlin.yuna.typemap.logic.ArgsDecoder;
import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.TypeMapI;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Channel;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.logging.LogService;

public abstract class NanoBase<T extends NanoBase<T>> {
    protected final Context context;
    protected final long createdAtNs;
    protected final LogService logService;
    protected final Map<Integer, Set<Consumer<? super Event<?, ?>>>> listeners = new ConcurrentHashMap();
    protected final AtomicBoolean isReady = new AtomicBoolean(true);
    protected final AtomicInteger eventCount = new AtomicInteger(0);
    public static final Map<Integer, Channel<?, ?>> EVENT_CHANNELS = new ConcurrentHashMap();
    public static final Map<String, String> CONFIG_KEYS = new ConcurrentHashMap<String, String>();
    public static final AtomicInteger EVENT_ID_COUNTER = new AtomicInteger(0);

    protected NanoBase(Map<Object, Object> configs, String ... args) {
        this.createdAtNs = System.nanoTime();
        this.context = this.readConfigs(args);
        if (configs != null) {
            configs.forEach((key, value) -> this.context.computeIfAbsent(TypeConverter.convertObj((Object)key, String.class), add -> Optional.ofNullable(value).orElse("")));
        }
        this.logService = new LogService();
        this.logService.context(this.context);
        this.logService.configure((TypeMapI<?>)this.context, (TypeMapI<?>)this.context);
        this.logService.start();
        this.logService.isReadyState().set(true);
        this.displayHelpMenu();
        this.subscribeEvent(Context.EVENT_CONFIG_CHANGE, (? super Event<C, R> event) -> this.context.putAll((Map)event.acknowledge().payload()));
    }

    abstract Context context(Class<?> var1);

    abstract T sendEvent(Event<?, ?> var1);

    abstract <C, R> Event<C, R> sendEventR(Event<C, R> var1);

    public abstract T stop(Class<?> var1);

    public abstract T stop(Context var1);

    public Map<Integer, Set<Consumer<? super Event<?, ?>>>> listeners() {
        return this.listeners;
    }

    public <C, R> T subscribeEvent(Channel<C, R> channel, Consumer<? super Event<C, R>> listener) {
        if (channel != null && listener != null) {
            this.listeners.computeIfAbsent(channel.id(), value -> ConcurrentHashMap.newKeySet()).add(listener);
        }
        return (T)this;
    }

    public <C, R> Consumer<Event<C, R>> subscribeEvent(Channel<C, R> channel, BiConsumer<? super Event<C, R>, C> listener) {
        Consumer<Event<C, R>> wrapped = event -> event.payloadOpt().ifPresent(payload -> listener.accept((Object)event, (Object)payload));
        this.listeners.computeIfAbsent(channel.id(), value -> ConcurrentHashMap.newKeySet()).add(wrapped);
        return wrapped;
    }

    public <C, R> Consumer<Event<Object, Void>> subscribeError(Channel<C, R> channel, Consumer<Event<C, R>> listener) {
        Consumer<Event<Object, Void>> wrapped = event -> event.channel(channel).ifPresent(listener);
        this.subscribeEvent(Context.EVENT_APP_ERROR, wrapped);
        return wrapped;
    }

    public <C, R> Consumer<Event<Object, Void>> subscribeError(Consumer<Event<Object, Void>> listener) {
        this.subscribeEvent(Context.EVENT_APP_ERROR, listener);
        return listener;
    }

    public <C, R> T unsubscribeEvent(int channelId, Consumer<Event<C, R>> listener) {
        this.listeners.getOrDefault(channelId, Collections.emptySet()).remove(listener);
        return (T)this;
    }

    public long pid() {
        return ProcessHandle.current().pid();
    }

    public double usedMemoryMB() {
        Runtime runtime = Runtime.getRuntime();
        return BigDecimal.valueOf((double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public double heapMemoryUsage() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return BigDecimal.valueOf((double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax()).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public long createdAtMs() {
        return this.createdAtNs;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public int eventCount() {
        return this.eventCount.get();
    }

    protected void displayHelpMenu() {
        if (this.context.asBooleanOpt(new Object[]{Context.APP_HELP}).filter(helpCalled -> helpCalled).isPresent(new Object[0])) {
            int keyLength = CONFIG_KEYS.keySet().stream().mapToInt(String::length).max().orElse(0);
            this.logService.log(() -> {
                LogRecord logRecord = new LogRecord(Level.INFO, "Available configs keys: " + System.lineSeparator() + CONFIG_KEYS.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(conf -> String.format("%-" + keyLength + "s  %s", conf.getKey(), conf.getValue())).collect(Collectors.joining(System.lineSeparator())));
                logRecord.setLoggerName(this.getClass().getCanonicalName());
                return logRecord;
            });
            if (((Boolean)this.context.asBooleanOpt(new Object[]{Context.CONFIG_ENV_PROD}).orElse((Object)false)).booleanValue()) {
                System.exit(0);
            }
        }
    }

    protected Context readConfigs(String ... args) {
        Context result = NanoUtils.readConfigFiles(null, "");
        System.getenv().forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> NanoUtils.addConfig(result, key, value)));
        if (args != null) {
            ArgsDecoder.argsOf((String)String.join((CharSequence)" ", args)).forEach((key, value) -> NanoUtils.addConfig(result, key, value));
        }
        return NanoUtils.resolvePlaceHolders(result);
    }

    public static String standardiseKey(Object key) {
        return key == null ? null : ((String)TypeConverter.convertObj((Object)key, String.class)).replace('.', '_').replace('-', '_').replace('+', '_').replace(':', '_').trim().toLowerCase();
    }
}

