/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.model.TypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.metric.logic.MetricService;
import org.nanonative.nano.services.metric.model.MetricType;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public abstract class Service {
    protected final long createdAtNs;
    protected final AtomicBoolean isReady = new AtomicBoolean(false);
    protected Context context;

    protected Service() {
        this.createdAtNs = System.nanoTime();
    }

    public abstract void start();

    public abstract void stop();

    public abstract Object onFailure(Event<?, ?> var1);

    public abstract void onEvent(Event<?, ?> var1);

    public void configure(TypeMapI<?> config) {
        this.configure(config, config);
    }

    public abstract void configure(TypeMapI<?> var1, TypeMapI<?> var2);

    public String name() {
        return this.getClass().getSimpleName();
    }

    public Context context() {
        return this.context;
    }

    public boolean isReady() {
        return this.isReady.get();
    }

    public AtomicBoolean isReadyState() {
        return this.isReady;
    }

    public Service context(Context context) {
        this.context = context;
        return this;
    }

    public long createdAtNs() {
        return this.createdAtNs;
    }

    public Service receiveEvent(Event<?, ?> event) {
        event.channel(Context.EVENT_CONFIG_CHANGE).map(Event::payload).map(map -> {
            if (map instanceof TypeMapI) {
                TypeMapI typeMap = (TypeMapI)map;
                return typeMap;
            }
            return new TypeMap(map);
        }).ifPresentOrElse(configs -> {
            TypeMap merged = new TypeMap((Map)((Object)this.context));
            this.context.forEach((arg_0, arg_1) -> merged.putIfAbsent(arg_0, arg_1));
            this.configure((TypeMapI<?>)configs, (TypeMapI<?>)merged);
            this.context.putAll((Map)configs);
        }, () -> this.onEvent(event));
        return this;
    }

    public NanoThread nanoThread(Context context) {
        return new NanoThread().run(() -> context.nano() != null ? context : null, () -> {
            long startTime = System.nanoTime();
            if (!this.isReady.get()) {
                this.context = context.newContext(this.getClass());
                this.configure((TypeMapI<?>)context);
                this.start();
                this.context.newEvent(Context.EVENT_APP_SERVICE_REGISTER).payload(() -> this).broadcast(true).send();
                this.context.newEvent(MetricService.EVENT_METRIC_UPDATE, () -> new MetricUpdate(MetricType.GAUGE, "application.services.ready.time", System.nanoTime() - startTime, Map.of("class", this.getClass().getSimpleName()))).async(true).send();
                this.isReady.set(true);
            }
        }).onComplete((nanoThread, error) -> {
            if (error != null) {
                this.context.sendEventError(context.newEvent(Context.EVENT_APP_SERVICE_REGISTER).payload(() -> this).error((Throwable)error), this, (Throwable)error);
            }
        });
    }

    public static NanoThread[] threadsOf(Context context, Service ... services) {
        return (NanoThread[])Arrays.stream(services).map(service -> service.nanoThread(context)).toArray(NanoThread[]::new);
    }
}

