/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.logging;

import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.model.Channel;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.logging.LogFormatRegister;
import org.nanonative.nano.services.logging.LogFormatterConsole;
import org.nanonative.nano.services.logging.model.LogLevel;

public class LogService
extends Service {
    public static final String CONFIG_LOG_LEVEL = ConfigRegister.registerConfig("app_log_level", "Log level for the application (see " + LogLevel.class.getSimpleName() + ")");
    public static final String CONFIG_LOG_FORMATTER = ConfigRegister.registerConfig("app_log_formatter", "Log formatter (see " + LogFormatRegister.class.getSimpleName() + ")");
    public static final String CONFIG_LOG_EXCLUDE_PATTERNS = ConfigRegister.registerConfig("app_log_excludes", "Exclude patterns for logger names");
    public static final Channel<LogRecord, Void> EVENT_LOGGING = Channel.registerChannelId("EVENT_LOGGING", LogRecord.class);
    public static final AtomicInteger MAX_LOG_NAME_LENGTH = new AtomicInteger(10);
    protected List<String> excludePatterns;
    protected Formatter logFormatter = new LogFormatterConsole();
    protected Level level = Level.FINE;

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object onFailure(Event<?, ?> error) {
        return null;
    }

    @Override
    public void onEvent(Event<?, ?> event) {
        event.channel(EVENT_LOGGING).filter(this::isLoggable).ifPresent(e -> e.payloadAckAsync(this::log));
    }

    @Override
    public void configure(TypeMapI<?> configs, TypeMapI<?> merged) {
        merged.asOpt(LogLevel.class, new Object[]{CONFIG_LOG_LEVEL}).map(LogLevel::toJavaLogLevel).ifPresent(this::level);
        merged.asOpt(Formatter.class, new Object[]{CONFIG_LOG_FORMATTER}).ifPresent(this::formatter);
        this.excludePatterns = (List)merged.asStringOpt(new Object[]{CONFIG_LOG_EXCLUDE_PATTERNS}).map(patterns -> Arrays.stream(patterns.split(",")).map(String::trim).toList()).orElseGet(List::of);
    }

    public synchronized LogService level(Level level) {
        this.level = level;
        return this;
    }

    public Level level() {
        return this.level;
    }

    public synchronized LogService formatter(Formatter formatter) {
        this.logFormatter = formatter;
        return this;
    }

    public Formatter formatter() {
        return this.logFormatter;
    }

    public void log(Supplier<LogRecord> logRecord) {
        this.context.run(() -> this.log((LogRecord)logRecord.get()));
    }

    protected boolean log(LogRecord logRecord) {
        this.context.run(() -> {
            String formattedMessage = this.logFormatter.format(logRecord);
            if (logRecord.getLevel().intValue() < Level.WARNING.intValue()) {
                System.out.print(formattedMessage);
            } else {
                System.err.print(formattedMessage);
            }
        });
        return true;
    }

    private <C, R> boolean isLoggable(Event<C, R> event) {
        return event.asOpt(Level.class, new Object[]{"level"}).filter(lvl -> lvl.intValue() > this.level.intValue()).map(lvl -> event.asString(new Object[]{"name"})).filter(name -> {
            if (this.excludePatterns == null) return true;
            if (!this.excludePatterns.stream().noneMatch(name::contains)) return false;
            return true;
        }).map(name -> event.acknowledge()).isPresent(new Object[0]);
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"name", (Object)this.getClass().getSimpleName())).putR((Object)"level", (Object)this.level)).putR((Object)"isReady", (Object)this.isReady.get())).putR((Object)"context", (Object)this.context.size())).putR((Object)"excludePatterns", (Object)(this.excludePatterns != null ? this.excludePatterns.size() : 0))).putR((Object)"logFormatter", (Object)this.logFormatter.getClass().getSimpleName())).putR((Object)"MAX_LOG_NAME_LENGTH", (Object)MAX_LOG_NAME_LENGTH.get())).putR((Object)"class", (Object)this.getClass().getSimpleName())).toJson();
    }
}

