/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Scheduler;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;

public abstract class NanoThreads<T extends NanoThreads<T>>
extends NanoBase<T> {
    protected final Set<ScheduledExecutorService> schedulers = ConcurrentHashMap.newKeySet();

    protected NanoThreads(Map<Object, Object> config, String ... args) {
        super(config, args);
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_REGISTER, (? super Event<C, R> event) -> this.schedulers.add((ScheduledExecutorService)event.payloadAck()));
        this.subscribeEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, (? super Event<C, R> event, C scheduler) -> {
            scheduler.shutdown();
            this.schedulers.remove(scheduler);
            event.acknowledge();
        });
    }

    public T run(Supplier<Context> context, ExRunnable task, LocalTime atTime, DayOfWeek dow, BooleanSupplier until) {
        return this.run(context, task, atTime, dow, ZoneId.systemDefault(), until);
    }

    public T runDaily(Supplier<Context> context, ExRunnable task, LocalTime atTime, BooleanSupplier until) {
        return this.run(context, task, atTime, null, ZoneId.systemDefault(), until);
    }

    public T runWeekly(Supplier<Context> context, ExRunnable task, DayOfWeek dow, LocalTime atTime, BooleanSupplier until) {
        return this.run(context, task, atTime, dow, ZoneId.systemDefault(), until);
    }

    public T run(Supplier<Context> context, ExRunnable task, LocalTime atTime, DayOfWeek dow, ZoneId zone, BooleanSupplier until) {
        Scheduler scheduler = this.asyncFromPool(context);
        ZonedDateTime firstPlanned = NanoThreads.initialPlanned(atTime, dow, zone);
        this.scheduleOnce(context, task, scheduler, until, atTime, dow, zone, firstPlanned);
        return (T)this;
    }

    protected void scheduleOnce(Supplier<Context> context, ExRunnable task, Scheduler scheduler, BooleanSupplier until, LocalTime atTime, DayOfWeek dow, ZoneId zone, ZonedDateTime planned) {
        long delayMs = Math.max(1L, Duration.between(ZonedDateTime.now(zone), planned).toMillis());
        scheduler.schedule(() -> {
            if (Optional.ofNullable(until).map(BooleanSupplier::getAsBoolean).filter(end -> end).isPresent()) {
                scheduler.shutdown();
                return;
            }
            this.executeScheduler(context, task, scheduler, true);
            this.scheduleOnce(context, task, scheduler, until, atTime, dow, zone, NanoThreads.nextPlanned(planned, atTime, dow, zone));
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    protected static ZonedDateTime initialPlanned(LocalTime atTime, DayOfWeek dow, ZoneId zone) {
        ZonedDateTime now = ZonedDateTime.now(zone);
        ZonedDateTime candidate = NanoThreads.resolveWallTime(now.toLocalDate(), atTime, zone);
        if (dow != null) {
            if ((candidate = candidate.with(TemporalAdjusters.nextOrSame(dow))).isBefore(now)) {
                candidate = NanoThreads.resolveWallTime(candidate.toLocalDate().plusWeeks(1L), atTime, zone);
            }
        } else if (candidate.isBefore(now)) {
            candidate = NanoThreads.resolveWallTime(now.toLocalDate().plusDays(1L), atTime, zone);
        }
        return candidate;
    }

    protected static ZonedDateTime nextPlanned(ZonedDateTime prevPlanned, LocalTime atTime, DayOfWeek dow, ZoneId zone) {
        return dow != null ? NanoThreads.resolveWallTime(prevPlanned.toLocalDate().plusWeeks(1L), atTime, zone) : NanoThreads.resolveWallTime(prevPlanned.toLocalDate().plusDays(1L), atTime, zone);
    }

    protected static ZonedDateTime resolveWallTime(LocalDate date, LocalTime time, ZoneId zone) {
        return ZonedDateTime.ofLocal(LocalDateTime.of(date, time), zone, null);
    }

    public Set<ScheduledExecutorService> schedulers() {
        return Collections.unmodifiableSet(this.schedulers);
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, TimeUnit timeUnit) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.schedule(() -> this.executeScheduler(context, task, scheduler, false), delay, timeUnit);
        return (T)this;
    }

    public T run(Supplier<Context> context, ExRunnable task, long delay, long period, TimeUnit unit, BooleanSupplier until) {
        Scheduler scheduler = this.asyncFromPool(context);
        scheduler.scheduleAtFixedRate(() -> {
            if (until.getAsBoolean()) {
                scheduler.shutdown();
            } else {
                this.executeScheduler(context, task, scheduler, true);
            }
        }, delay, period, unit);
        return (T)this;
    }

    protected Scheduler asyncFromPool(final Supplier<Context> context) {
        final String schedulerId = NanoUtils.callerInfoStr(this.getClass()) + "_" + String.valueOf(UUID.randomUUID());
        Scheduler scheduler = new Scheduler(this, schedulerId){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                t.setName("Scheduler_" + schedulerId);
                try {
                    NanoThread.GLOBAL_THREAD_POOL.submit(r);
                }
                catch (Throwable error) {
                    NanoUtils.handleJavaError(context, error);
                }
            }
        };
        this.context(Scheduler.class).newEvent(Context.EVENT_APP_SCHEDULER_REGISTER, () -> scheduler).broadcast(true).async(true).send();
        return scheduler;
    }

    protected void shutdownThreads() {
        long timeoutMs = (Long)this.context.asLongOpt(new Object[]{Context.CONFIG_THREAD_POOL_TIMEOUT_MS}).filter(l -> l > 0L).orElse((Object)500L);
        this.context.debug(() -> "Shutdown schedulers [{}]", this.schedulers.size());
        this.shutdownExecutors(timeoutMs, (ExecutorService[])this.schedulers.toArray(ScheduledExecutorService[]::new));
    }

    protected void shutdownExecutors(long timeoutMs, ExecutorService ... executorServices) {
        Arrays.stream(executorServices).forEach(ExecutorService::shutdown);
        ((Stream)Arrays.stream(executorServices).parallel()).forEach(executorService -> {
            executorService.shutdown();
            try {
                this.kill((ExecutorService)executorService, timeoutMs);
                this.removeScheduler((ExecutorService)executorService);
            }
            catch (InterruptedException ie) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        });
    }

    protected void removeScheduler(ExecutorService executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)executorService;
            this.schedulers.remove(scheduler);
        }
    }

    protected void kill(ExecutorService executorService, long timeoutMs) throws InterruptedException {
        if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            this.context.debug(() -> "Kill [{}]", NanoUtils.getThreadName(executorService));
            executorService.shutdownNow();
            if (!executorService.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                this.context.warn(() -> "[{}] did not terminate. Is this a glitch in the Matrix?", NanoUtils.getThreadName(executorService));
            }
        }
    }

    protected void executeScheduler(Supplier<Context> context, ExRunnable task, Scheduler scheduler, boolean periodically) {
        Context ctx = Optional.ofNullable(context).map(Supplier::get).orElse(this.context);
        try {
            task.run();
            if (!periodically) {
                ctx.newEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, () -> scheduler).broadcast(true).async(true).send();
            }
        }
        catch (Throwable e) {
            NanoUtils.handleJavaError(context, e);
            ctx.newEvent(Context.EVENT_APP_SCHEDULER_UNREGISTER, () -> scheduler).broadcast(true).async(true).send();
            ctx.sendEventError(scheduler, e);
        }
    }
}

