/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.event.model;

import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.Type;
import berlin.yuna.typemap.model.TypeMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.event.model.Channel;

public class Event<C, R>
extends TypeMap {
    protected final transient Channel<C, R> channel;
    protected final Context context;
    protected transient Consumer<R> responseListener;
    protected transient Supplier<C> payload;
    protected transient C payloadRaw;
    protected transient R response;
    protected Throwable error;
    protected final AtomicBoolean isAcknowledged = new AtomicBoolean(false);

    public Event(Context context, Channel<C, R> channel) {
        this.context = context;
        this.channel = channel;
        this.put("createdAt", System.nanoTime());
    }

    public Channel<C, R> channel() {
        return this.channel;
    }

    public <A, B> Optional<Event<A, B>> channel(Channel<A, B> channel) {
        return this.channel.id() == channel.id() ? Optional.of(this) : (this.containsEvent() ? ((Event)((Object)this.payload())).channel(channel) : Optional.empty());
    }

    public Event<C, R> async(boolean async) {
        this.responseListener = async ? ignored -> {} : null;
        return this;
    }

    public Event<C, R> async(Consumer<R> responseListener) {
        this.responseListener = responseListener;
        return this;
    }

    public Event<C, R> payload(Supplier<C> payload) {
        this.payload = payload;
        return this;
    }

    public C payloadAck() {
        return this.acknowledge().payload();
    }

    public Optional<C> payloadOpt() {
        return Optional.ofNullable(this.payload());
    }

    public Optional<C> payloadAckOpt() {
        return Optional.ofNullable(this.payload()).map(c -> {
            this.respond(null);
            return c;
        });
    }

    public Event<C, R> payloadAsync(Consumer<C> consumer) {
        if (this.payload != null) {
            this.context.run(() -> consumer.accept(this.payload()));
        }
        return this;
    }

    public Event<C, R> payloadAckAsync(Consumer<C> consumer) {
        this.acknowledge();
        return this.payloadAsync(consumer);
    }

    public C payload() {
        if (this.payloadRaw == null && this.payload != null) {
            this.payloadRaw = this.payload.get();
            if (this.payloadRaw instanceof Event) {
                this.containsEvent(true);
                ((Event)((Object)this.payloadRaw)).put("parentEvent", (Object)this);
            }
        }
        return this.payloadRaw;
    }

    public boolean isAcknowledged() {
        return this.isAcknowledged.getPlain();
    }

    public Event<C, R> acknowledge() {
        return this.respond(null);
    }

    public boolean isBroadcast() {
        return (Boolean)this.asBooleanOpt(new Object[]{"isBroadcast"}).orElse((Object)false);
    }

    public Event<C, R> broadcast(boolean broadcast) {
        this.put("isBroadcast", broadcast);
        return this;
    }

    public Context context() {
        return this.context;
    }

    public boolean isAsync() {
        return this.responseListener != null;
    }

    public boolean containsEvent() {
        return (Boolean)this.asBooleanOpt(new Object[]{"containsEvent"}).orElse((Object)false);
    }

    public Event<C, R> containsEvent(boolean containsEvent) {
        return this.putR("containsEvent", containsEvent);
    }

    public Consumer<R> listener() {
        return this.responseListener;
    }

    public Event<C, R> respond(R response) {
        if (this.responseListener != null) {
            this.responseListener.accept(response);
        }
        this.response = response;
        if (!this.isAcknowledged()) {
            Optional.ofNullable(this.get("parentEvent")).filter(Event.class::isInstance).map(Event.class::cast).ifPresentOrElse(event -> event.isAcknowledged.set(true), () -> Optional.of(this.containsEvent()).filter((? super T containsEvent) -> containsEvent).flatMap(containsEvent -> this.payloadOpt()).filter(Event.class::isInstance).map(Event.class::cast).ifPresent(event -> event.isAcknowledged.set(true)));
        }
        this.isAcknowledged.set(true);
        return this;
    }

    public R response() {
        return this.response;
    }

    public Optional<R> responseOpt() {
        return Optional.ofNullable(this.response);
    }

    public <T> Optional<T> responseOpt(Class<T> type) {
        return Optional.ofNullable(this.channel.response().isAssignableFrom(type) ? (Object)this.response : null);
    }

    public Event<C, R> peek(Consumer<Event<C, R>> peek) {
        if (peek != null) {
            peek.accept(this);
        }
        return this;
    }

    public Event<C, R> putR(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    public Type<Event<C, R>> filter(Predicate<Event<C, R>> predicate) {
        return new Type((Object)(predicate.test(this) ? this : null));
    }

    public Throwable error() {
        return this.error == null ? (Throwable)Optional.ofNullable(this.get("parentEvent")).filter(Event.class::isInstance).map(Event.class::cast).map(Event::error).or(() -> Optional.of(this.containsEvent()).filter((? super T containsEvent) -> containsEvent).flatMap(containsEvent -> this.payloadOpt()).filter(Event.class::isInstance).map(Event.class::cast).map(Event::error)).orElse(null) : this.error;
    }

    public Event<C, R> error(Throwable error) {
        this.error = error;
        return this;
    }

    public Event<C, R> send() {
        this.context.nano().sendEvent(this);
        return this;
    }

    public Context sendR() {
        this.context.nano().sendEvent(this);
        return this.context;
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"channel", this.channel())).putR((Object)"ack", (Object)(this.response != null ? 1 : 0))).putR((Object)"listener", (Object)(this.responseListener != null ? 1 : 0))).putR((Object)"payload", Optional.ofNullable(this.payload()).map(Object::toString).orElse(null))).putR((Object)"class", (Object)((Object)((Object)this)).getClass().getSimpleName())).putR((Object)"size", (Object)(this.context.size() + this.size() + (this.payload == null ? 0 : 1) + (this.responseListener == null ? 0 : 1) + (this.response == null ? 0 : 1) + (this.error == null ? 0 : 1)))).toJson();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.channel == event.channel && Objects.equals((Object)this.context, (Object)event.context) && Objects.equals(this.responseListener, event.responseListener) && Objects.equals(this.payload, event.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.channel, this.context, this.responseListener, this.payload});
    }
}

