/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.file;

import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.event.model.Channel;
import org.nanonative.nano.helper.event.model.Event;

public class FileWatcher
extends Service {
    public static final Channel<Path, Void> EVENT_WATCH_FILE = Channel.registerChannelId("WATCH_FILE", Path.class);
    public static final Channel<Path, Void> EVENT_UNWATCH_FILE = Channel.registerChannelId("UNWATCH_FILE", Path.class);
    public static final Channel<Path, Void> EVENT_FILE_CHANGE = Channel.registerChannelId("FILE_CHANGE", Path.class);
    private WatchService watchService;
    private Map<WatchKey, Path> watchedKeys;
    private Map<Path, WatchKey> pathToKey;

    @Override
    public void start() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.watchedKeys = new ConcurrentHashMap<WatchKey, Path>();
            this.pathToKey = new ConcurrentHashMap<Path, WatchKey>();
            this.context.run(() -> {
                while (this.watchService != null) {
                    try {
                        WatchKey key = this.watchService.take();
                        Path watchedDir = this.watchedKeys.get(key);
                        if (watchedDir != null) {
                            for (WatchEvent<?> event : key.pollEvents()) {
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                                Path eventPath = watchedDir.resolve((Path)event.context());
                                this.context.newEvent(EVENT_FILE_CHANGE).putR("kind", kind.name()).payload(() -> eventPath).send();
                                if (kind != StandardWatchEventKinds.ENTRY_DELETE || !this.pathToKey.containsKey(eventPath)) continue;
                                this.unwatch(eventPath);
                            }
                        }
                        key.reset();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ClosedWatchServiceException closedWatchServiceException) {}
                }
            });
        }
        catch (Exception e) {
            this.context.error(() -> "Failed to initialize " + this.getClass().getSimpleName(), e);
        }
    }

    @Override
    public void stop() {
        Optional.ofNullable(this.watchedKeys).ifPresent(map -> {
            map.keySet().forEach(WatchKey::cancel);
            map.clear();
        });
        Optional.ofNullable(this.pathToKey).ifPresent(Map::clear);
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.watchService = null;
    }

    @Override
    public Object onFailure(Event<?, ?> error) {
        return null;
    }

    @Override
    public void onEvent(Event<?, ?> event) {
        event.channel(EVENT_WATCH_FILE).map(Event::payloadAck).ifPresent(this::watch);
        event.channel(EVENT_UNWATCH_FILE).map(Event::payloadAck).ifPresent(this::unwatch);
    }

    public boolean watch(Path path) {
        try {
            if (this.pathToKey.containsKey(path)) {
                return true;
            }
            WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchedKeys.put(key, path);
            this.pathToKey.put(path, key);
            return true;
        }
        catch (Exception e) {
            this.context.error(e, () -> "Failed to watch path [%s]", path);
            return false;
        }
    }

    public void unwatch(Path path) {
        WatchKey key = this.pathToKey.remove(path);
        if (key != null) {
            key.cancel();
            this.watchedKeys.remove(key);
        }
    }

    @Override
    public void configure(TypeMapI<?> changes, TypeMapI<?> merged) {
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"watchedKeys", (Object)this.watchedKeys.size())).putR((Object)"pathToKey", (Object)this.pathToKey.size())).putR((Object)"class", (Object)this.getClass().getSimpleName())).toJson();
    }
}

