/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.model.Channel;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.file.FileWatcher;
import org.nanonative.nano.services.http.HttpClient;
import org.nanonative.nano.services.http.HttpsHelper;
import org.nanonative.nano.services.http.model.HttpObject;

public class HttpServer
extends Service {
    protected com.sun.net.httpserver.HttpServer server;
    public static final String CONFIG_SERVICE_HTTP_PORT = ConfigRegister.registerConfig("app_service_http_port", "Default port for the HTTP service (see " + HttpServer.class.getSimpleName() + ")");
    public static final String CONFIG_SERVICE_HTTP_CLIENT = ConfigRegister.registerConfig("app_service_http_client", "Boolean if " + HttpClient.class.getSimpleName() + " should start as well");
    public static final String CONFIG_SERVICE_HTTPS_CERTS = ConfigRegister.registerConfig("app_service_https_certs", "Comma-separated paths to SSL certificates, private keys, or keystores. Can be files or directories.");
    public static final String CONFIG_SERVICE_HTTPS_CERT = ConfigRegister.registerConfig("app_service_https_cert", "SSL certificate path");
    public static final String CONFIG_SERVICE_HTTPS_CA = ConfigRegister.registerConfig("app_service_https_ca", "SSL CA certificate path");
    public static final String CONFIG_SERVICE_HTTPS_KEY = ConfigRegister.registerConfig("app_service_https_key", "SSL private key path");
    public static final String CONFIG_SERVICE_HTTPS_KTS = ConfigRegister.registerConfig("app_service_https_kts", "SSL keystore path");
    public static final String CONFIG_SERVICE_HTTPS_PASSWORD = ConfigRegister.registerConfig("app_service_https_password", "Optional password for SSL keystores/private keys");
    public static final Channel<HttpObject, HttpObject> EVENT_HTTP_REQUEST = Channel.registerChannelId("HTTP_REQUEST", HttpObject.class, HttpObject.class);
    public static final Channel<HttpObject, HttpObject> EVENT_HTTP_REQUEST_UNHANDLED = Channel.registerChannelId("HTTP_REQUEST_UNHANDLED", HttpObject.class, HttpObject.class);
    protected static final Lock STARTUP_LOCK = new ReentrantLock();

    public InetSocketAddress address() {
        return this.server == null ? null : this.server.getAddress();
    }

    public int port() {
        return this.server == null ? -1 : this.server.getAddress().getPort();
    }

    public com.sun.net.httpserver.HttpServer server() {
        return this.server;
    }

    @Override
    public void start() {
        try {
            STARTUP_LOCK.lock();
            if (this.context.containsKey(CONFIG_SERVICE_HTTPS_CERT) || this.context.containsKey(CONFIG_SERVICE_HTTPS_KEY) || this.context.containsKey(CONFIG_SERVICE_HTTPS_CA) || this.context.containsKey(CONFIG_SERVICE_HTTPS_KTS)) {
                this.server = HttpsHelper.createHttpsServer(this.context);
                HttpsHelper.configureHttps(this.context, this.server);
                if (this.context.service(FileWatcher.class) == null) {
                    this.context.runAwait(new FileWatcher());
                }
            } else {
                this.server = HttpsHelper.createDefaultServer(this.context);
            }
            this.server.setExecutor(NanoThread.GLOBAL_THREAD_POOL);
            this.server.createContext("/", exchange -> {
                HttpObject request = new HttpObject(exchange);
                Event<HttpObject, HttpObject> event = this.context.newEvent(EVENT_HTTP_REQUEST, () -> request);
                try {
                    AtomicBoolean internalError = new AtomicBoolean(false);
                    event.send().peek(HttpServer.setError(internalError)).responseOpt().ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.context.newEvent(EVENT_HTTP_REQUEST_UNHANDLED, () -> request).send().responseOpt().ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.sendResponse(exchange, request, new HttpObject().failure(internalError.get() ? 500 : 404, internalError.get() ? "Internal Server Error" : "Not Found", null))));
                }
                catch (Exception e) {
                    this.context.newEvent(Context.EVENT_APP_ERROR).payload(() -> event).error(e).containsEvent(true).send();
                    event.responseOpt().ifPresentOrElse(response -> this.sendResponse(exchange, request, (HttpObject)response), () -> this.sendResponse(exchange, request, new HttpObject().failure(500, "Internal Server Error", null)));
                }
            });
            this.server.start();
            this.context.info(() -> "[{}] starting on port [{}]", this.name(), this.context.get(CONFIG_SERVICE_HTTP_PORT));
            this.context.asBooleanOpt(new Object[]{CONFIG_SERVICE_HTTP_CLIENT}).map(shouldStart -> this.context.service(HttpClient.class) == null ? Boolean.valueOf(true) : null).ifPresent(start -> this.context.runAwait(new HttpClient()));
        }
        catch (IOException e) {
            this.context.error(e, () -> "[{}] failed to start with port [{}]", this.name(), this.context.get(CONFIG_SERVICE_HTTP_PORT));
        }
        finally {
            STARTUP_LOCK.unlock();
        }
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.context.info(() -> "[{}] port [{}] stopped", this.name(), this.server.getAddress().getPort());
            this.server = null;
        }
    }

    @Override
    public void onEvent(Event<?, ?> event) {
    }

    @Override
    public void configure(TypeMapI<?> configs, TypeMapI<?> merged) {
        if (configs.containsKey((Object)CONFIG_SERVICE_HTTPS_CERTS) || configs.containsKey((Object)CONFIG_SERVICE_HTTPS_CERT) || configs.containsKey((Object)CONFIG_SERVICE_HTTPS_KEY) || configs.containsKey((Object)CONFIG_SERVICE_HTTPS_CA) || configs.containsKey((Object)CONFIG_SERVICE_HTTPS_KTS)) {
            merged.asStringOpt(new Object[]{CONFIG_SERVICE_HTTPS_CERTS}).map(certPaths -> {
                Arrays.stream(certPaths.split(",")).map(String::trim).filter(NanoUtils::hasText).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(NanoUtils::listFiles).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(path -> {
                    String fileName = path.getFileName().toString().toLowerCase();
                    if (fileName.endsWith(".key") && this.context.asPath(new Object[]{CONFIG_SERVICE_HTTPS_KEY}) == null) {
                        this.context.put(CONFIG_SERVICE_HTTPS_KEY, path);
                    } else if (fileName.endsWith(".crt") && this.context.asPath(new Object[]{CONFIG_SERVICE_HTTPS_CERT}) == null) {
                        this.context.put(CONFIG_SERVICE_HTTPS_CERT, path);
                    } else if (fileName.endsWith(".ca") && this.context.asPath(new Object[]{CONFIG_SERVICE_HTTPS_CA}) == null) {
                        this.context.put(CONFIG_SERVICE_HTTPS_CA, path);
                    } else if (fileName.endsWith(".kts") && this.context.asPath(new Object[]{CONFIG_SERVICE_HTTPS_KTS}) == null) {
                        this.context.put(CONFIG_SERVICE_HTTPS_KTS, path);
                    }
                });
                return true;
            }).ifPresent(certChanges -> {
                HttpsHelper.configureHttps(this.context, this.server);
                this.context.run(() -> {});
            });
        }
    }

    @Override
    public Object onFailure(Event<?, ?> error) {
        return null;
    }

    protected void sendResponse(HttpExchange exchange, HttpObject request, HttpObject response) {
        try {
            byte[] body = response.body();
            int statusCode = response.statusCode() > -1 && response.statusCode() < 600 ? response.statusCode() : 200;
            Optional<String> encoding = request.acceptEncodings().stream().filter(s -> s.equals("gzip") || s.equals("deflate")).findFirst();
            response.headerMap().remove((Object)"#throwable#");
            response.headerMap().asMap(String.class, value -> TypeConverter.collectionOf((Object)value, String.class), new Object[0]).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            response.computedHeaders(false).forEach((key, value) -> exchange.getResponseHeaders().put((String)key, (List<String>)value));
            if (encoding.isPresent()) {
                body = this.encodeBody(body, encoding.get());
            }
            exchange.getResponseHeaders().put("content-encoding", List.of(encoding.orElse("identity")));
            exchange.sendResponseHeaders(statusCode, body.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(body);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected byte[] encodeBody(byte[] body, String contentEncoding) {
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeGzip(body);
        }
        if ("deflate".equalsIgnoreCase(contentEncoding)) {
            return NanoUtils.encodeDeflate(body);
        }
        return body;
    }

    public static Consumer<Event<HttpObject, HttpObject>> setError(AtomicBoolean internalError) {
        return event -> {
            if (event.error() != null) {
                internalError.set(true);
            }
        };
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"name", (Object)this.port())).putR((Object)"class", (Object)this.getClass().getSimpleName())).toJson();
    }
}

