/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core.model;

import berlin.yuna.typemap.model.LinkedTypeMap;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.helper.ExRunnable;
import org.nanonative.nano.helper.NanoUtils;

public class NanoThread {
    protected final List<BiConsumer<NanoThread, Throwable>> listeners = new CopyOnWriteArrayList<BiConsumer<NanoThread, Throwable>>();
    protected final AtomicBoolean isComplete = new AtomicBoolean();
    public static final ExecutorService GLOBAL_THREAD_POOL = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("nano-thread-", 0L).factory());
    protected static final AtomicLong activeNanoThreadCount = new AtomicLong(0L);
    private volatile Future<?> future;

    public boolean isComplete() {
        return this.isComplete.get();
    }

    public NanoThread onComplete(BiConsumer<NanoThread, Throwable> listener) {
        if (this.isComplete.get()) {
            listener.accept(this, null);
            return this;
        }
        this.listeners.add(listener);
        if (this.isComplete.get()) {
            listener.accept(this, null);
        }
        return this;
    }

    public NanoThread await() {
        return this.await(null);
    }

    public NanoThread await(Runnable onDone) {
        return NanoThread.waitFor(onDone, this)[0];
    }

    public NanoThread run(Supplier<Context> context, ExRunnable task) {
        this.future = GLOBAL_THREAD_POOL.submit(() -> {
            try {
                activeNanoThreadCount.incrementAndGet();
                task.run();
                this.markComplete(null);
            }
            catch (Throwable error) {
                NanoUtils.handleJavaError(context, error);
                this.markComplete(error);
                Optional.ofNullable(context).map(Supplier::get).ifPresent(ctx -> ctx.sendEventError(task, error));
            }
            finally {
                activeNanoThreadCount.decrementAndGet();
            }
        });
        return this;
    }

    private void markComplete(Throwable error) {
        if (this.isComplete.compareAndSet(false, true)) {
            for (BiConsumer<NanoThread, Throwable> l : this.listeners) {
                try {
                    l.accept(this, error);
                }
                catch (Exception exception) {}
            }
            this.listeners.clear();
        }
    }

    public Future<?> future() {
        return this.future;
    }

    public NanoThread future(Future<?> future) {
        this.future = future;
        return this;
    }

    public static long activeNanoThreads() {
        return activeNanoThreadCount.get();
    }

    public static long activeCarrierThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadMXBean.getAllThreadIds();
        return Arrays.stream(threadMXBean.getThreadInfo(threadIds)).filter(Objects::nonNull).filter(info -> info.getThreadName() != null && info.getThreadName().startsWith("CarrierThread") || info.getLockName() != null && info.getLockName().startsWith("java.lang.VirtualThread") || info.getLockName() != null && info.getLockName().startsWith("nano-thread-") || info.getLockOwnerName() != null && info.getLockName().startsWith("nano-thread-")).count();
    }

    public static NanoThread[] waitFor(NanoThread ... threads) {
        return NanoThread.waitFor(null, threads);
    }

    public static NanoThread[] waitFor(Runnable onComplete, NanoThread ... threads) {
        CountDownLatch latch = new CountDownLatch(threads.length);
        for (NanoThread thread : threads) {
            thread.onComplete((nt, error) -> {
                latch.countDown();
                if (!(error instanceof Error) && latch.getCount() == 0L && onComplete != null) {
                    onComplete.run();
                }
            });
        }
        if (onComplete == null) {
            try {
                if (!latch.await(10000L, TimeUnit.MILLISECONDS)) {
                    System.err.println(String.valueOf(new Date()) + " [FATAL] Threads did not complete in 10000ms");
                    for (NanoThread t : threads) {
                        if (t.future() == null) continue;
                        t.future().cancel(true);
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        return threads;
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"class", (Object)this.getClass().getSimpleName())).putR((Object)"listener", (Object)this.listeners.size())).putR((Object)"isComplete", (Object)this.isComplete.get())).toJson();
    }
}

