/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http;

import berlin.yuna.typemap.logic.TypeConverter;
import berlin.yuna.typemap.model.LinkedTypeMap;
import berlin.yuna.typemap.model.TypeMapI;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.config.ConfigRegister;
import org.nanonative.nano.helper.event.model.Channel;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.http.HttpsHelper;
import org.nanonative.nano.services.http.model.HttpObject;

public class HttpClient
extends Service {
    public static final String CONFIG_HTTP_CLIENT_VERSION = ConfigRegister.registerConfig("app_service_http_version", "HTTP client version 1 or 2 (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_MAX_RETRIES = ConfigRegister.registerConfig("app_service_http_max_retries", "Maximum number of retries for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_CON_TIMEOUT_MS = ConfigRegister.registerConfig("app_service_http_con_timeout_ms", "Connection timeout in milliseconds for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_READ_TIMEOUT_MS = ConfigRegister.registerConfig("app_service_http_read_timeout_ms", "Read timeout in milliseconds for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_FOLLOW_REDIRECTS = ConfigRegister.registerConfig("app_service_http_follow_redirects", "Follow redirects for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_TRUST_ALL = ConfigRegister.registerConfig("app_service_http_trust_all", "Trust all certificates for the HTTP client (see " + HttpClient.class.getSimpleName() + ")");
    public static final String CONFIG_HTTP_CLIENT_TRUSTED_CA = ConfigRegister.registerConfig("app_service_http_trusted_ca", "File or Folder Path to CA certificate to trust. Default == OS && Java level (see " + HttpClient.class.getSimpleName() + ").");
    public static final Channel<HttpObject, HttpObject> EVENT_SEND_HTTP = Channel.registerChannelId("SEND_HTTP", HttpObject.class, HttpObject.class);
    protected java.net.http.HttpClient client;
    protected int retries = 3;
    protected long readTimeoutMs = 10000L;

    @Override
    public void start() {
        HttpClient.Builder config = java.net.http.HttpClient.newBuilder().connectTimeout(Duration.ofMillis((Long)this.context.asLongOpt(new Object[]{CONFIG_HTTP_CLIENT_CON_TIMEOUT_MS}).orElse((Object)5000L))).followRedirects((Boolean)this.context.asBooleanOpt(new Object[]{CONFIG_HTTP_CLIENT_FOLLOW_REDIRECTS}).orElse((Object)true) != false ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).version((HttpClient.Version)((Object)this.context.asOpt(HttpClient.Version.class, new Object[]{CONFIG_HTTP_CLIENT_VERSION}).orElse((Object)HttpClient.Version.HTTP_2))).executor(NanoThread.GLOBAL_THREAD_POOL);
        this.context.asStringOpt(new Object[]{CONFIG_HTTP_CLIENT_TRUSTED_CA}).filter(NanoUtils::hasText).map(String::trim).map(s -> "default".equalsIgnoreCase((String)s) ? HttpsHelper.findDefaultLinuxCaBundle() : List.of((Path)TypeConverter.convertObj((Object)s, Path.class))).ifPresentOrElse(trustedCertPath -> config.sslContext(HttpsHelper.createCustomTrustedSslContext(this.context, trustedCertPath)), () -> this.context.asBooleanOpt(new Object[]{CONFIG_HTTP_CLIENT_TRUST_ALL}).filter(b -> b).ifPresent(b -> config.sslContext(HttpsHelper.createTrustedSslContext())));
        this.client = config.build();
    }

    @Override
    public void stop() {
        this.client.close();
        this.client = null;
    }

    @Override
    public Object onFailure(Event<?, ?> error) {
        return null;
    }

    @Override
    public void onEvent(Event<?, ?> event) {
        event.channel(EVENT_SEND_HTTP).ifPresent(e -> e.respond(this.send((HttpRequest)e.payload(), (Consumer)event.as(Consumer.class, new Object[]{"callback"}))));
    }

    @Override
    public void configure(TypeMapI<?> changes, TypeMapI<?> merged) {
        changes.asIntOpt(new Object[]{CONFIG_HTTP_CLIENT_MAX_RETRIES}).ifPresent(value -> {
            this.retries = value;
        });
        changes.asIntOpt(new Object[]{CONFIG_HTTP_CLIENT_READ_TIMEOUT_MS}).ifPresent(value -> {
            this.readTimeoutMs = value.intValue();
        });
    }

    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"version", (Object)this.version())).putR((Object)"retries", (Object)this.retries)).putR((Object)"followRedirects", (Object)this.followRedirects())).putR((Object)"readTimeoutMs", (Object)this.readTimeoutMs)).putR((Object)"connectionTimeoutMs", (Object)this.connectionTimeoutMs())).putR((Object)"class", (Object)this.getClass().getSimpleName())).toJson();
    }

    public HttpObject send(HttpRequest request) {
        return this.send(request, null);
    }

    public HttpObject send(HttpRequest request, Consumer<HttpObject> callback) {
        if (request instanceof HttpObject) {
            HttpObject httpObject = (HttpObject)request;
            httpObject.timeout(this.readTimeoutMs);
        }
        return request != null ? this.send(0, request, new HttpObject(), callback) : new HttpObject().failure(400, new IllegalArgumentException("Invalid request [null]"));
    }

    public int retries() {
        return this.retries;
    }

    public boolean followRedirects() {
        return HttpClient.Redirect.ALWAYS.equals((Object)this.client.followRedirects());
    }

    public long readTimeoutMs() {
        return this.readTimeoutMs;
    }

    public long connectionTimeoutMs() {
        return this.client.connectTimeout().map(Duration::toMillis).orElse(-1L);
    }

    public HttpClient.Version version() {
        return this.client.version();
    }

    public java.net.http.HttpClient client() {
        return this.client;
    }

    protected HttpObject send(int attempt, HttpRequest request, HttpObject response, Consumer<HttpObject> callback) {
        if (this.client == null) {
            this.configure((TypeMapI<?>)this.context);
        }
        try {
            if (callback == null) {
                return this.responseOf(this.client.send(request, HttpResponse.BodyHandlers.ofByteArray()), response);
            }
            ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenAccept(httpResponse -> this.responseOf((HttpResponse<byte[]>)httpResponse, response))).thenRun(() -> callback.accept(response));
        }
        catch (IOException e) {
            return this.circuitBreaker(attempt, request, response, callback, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            return response.path(request.uri().toString()).statusCode(400).failure(-1, e);
        }
        return response;
    }

    protected HttpObject responseOf(HttpResponse<byte[]> httpResponse, HttpObject response) {
        HttpObject result = response.statusCode(httpResponse.statusCode()).methodType(httpResponse.request().method()).path(httpResponse.uri().getPath()).headerMap(httpResponse.headers().map());
        return result.body(httpResponse.body());
    }

    protected HttpObject circuitBreaker(int attempt, HttpRequest request, HttpObject response, Consumer<HttpObject> callback, Throwable throwable) {
        if (attempt < this.retries) {
            try {
                Thread.sleep((long)Math.pow(2.0, attempt) * 256L);
                return this.send(attempt + 1, request, response, callback);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return response.path(request.uri().toString()).failure(-99, ie);
            }
        }
        return response.path(request.uri().toString()).failure(-1, throwable);
    }
}

