/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.core;

import berlin.yuna.typemap.model.FunctionOrNull;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.nanonative.nano.core.NanoServices;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.core.model.NanoThread;
import org.nanonative.nano.core.model.Service;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.helper.event.model.Event;
import org.nanonative.nano.services.logging.LogService;
import org.nanonative.nano.services.metric.logic.MetricService;
import org.nanonative.nano.services.metric.model.MetricType;
import org.nanonative.nano.services.metric.model.MetricUpdate;

public class Nano
extends NanoServices<Nano> {
    public Nano(Service ... startupServices) {
        this((String[])null, startupServices);
    }

    public Nano(String[] args, Service ... startupServices) {
        this((FunctionOrNull<Context, List<Service>>)((FunctionOrNull)context -> Arrays.asList(startupServices)), null, args);
    }

    public Nano(Map<Object, Object> config, Service ... startupServices) {
        this((FunctionOrNull<Context, List<Service>>)((FunctionOrNull)ctx -> List.of(startupServices)), config, new String[0]);
    }

    public Nano(Map<Object, Object> config, FunctionOrNull<Context, List<Service>> startupServices) {
        this(startupServices, config, new String[0]);
    }

    public Nano(String[] args, FunctionOrNull<Context, List<Service>> startupServices) {
        this(startupServices, null, args);
    }

    public Nano(FunctionOrNull<Context, List<Service>> startupServices, Map<Object, Object> config, String ... args) {
        super(config, args);
        this.context.put("app_core_context_nano", this);
        this.context.put("app_core_context_class", this.getClass());
        long initTime = System.nanoTime() - this.createdAtNs;
        this.context.trace(() -> "Init [{}] in [{}]", this.getClass().getSimpleName(), NanoUtils.formatDuration(initTime));
        this.printParameters();
        long service_startUpTime = System.nanoTime();
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown(this.context(this.getClass()))));
            this.startServicesAndLogger(startupServices);
            this.context.computeIfAbsent("app_nano_name", k -> NanoUtils.generateNanoName("%s%.0s%.0s%.0s"));
            this.run(() -> this.context, () -> this.context.newEvent(Context.EVENT_APP_HEARTBEAT).async(true).send(), 256L, 256L, TimeUnit.MILLISECONDS, () -> false);
            this.run(() -> this.context, System::gc, 5L, 5L, TimeUnit.SECONDS, () -> false);
            long readyTime = System.nanoTime() - service_startUpTime;
            this.printActiveProfiles();
            this.context.info(() -> "Started [{}] in [{}]", this.context.asString(new Object[]{"app_nano_name"}), NanoUtils.formatDuration(readyTime));
            this.printSystemInfo();
            this.context.newEvent(MetricService.EVENT_METRIC_UPDATE, () -> new MetricUpdate(MetricType.GAUGE, "application.started.time", initTime, null)).async(true).send();
            this.context.newEvent(MetricService.EVENT_METRIC_UPDATE, () -> new MetricUpdate(MetricType.GAUGE, "application.ready.time", readyTime, null)).async(true).send();
            this.subscribeEvent(Context.EVENT_APP_SHUTDOWN, (? super Event<C, R> event) -> {
                NanoThread.GLOBAL_THREAD_POOL.submit(() -> this.shutdown(event.context()));
                event.acknowledge();
            });
            this.subscribeEvent(Context.EVENT_APP_HEARTBEAT, this::cleanUps);
            this.context.newEvent(Context.EVENT_APP_START).broadcast(true).async(true).send();
        }
        catch (Exception e) {
            this.context.error(e, () -> "Failed to start [{}] in [{}]", this.getClass().getSimpleName(), NanoUtils.formatDuration(System.nanoTime() - service_startUpTime));
            this.shutdown(this.context);
        }
    }

    public Context context() {
        return this.context;
    }

    @Override
    public Context context(Class<?> clazz) {
        return this.context.newContext(clazz);
    }

    public Context contextEmpty(Class<?> clazz) {
        return this.context.newEmptyContext(clazz);
    }

    @Override
    public Nano stop(Class<?> clazz) {
        return this.stop(clazz != null ? this.context(clazz) : null);
    }

    @Override
    public Nano stop(Context context) {
        (context != null ? context : this.context(this.getClass())).newEvent(Context.EVENT_APP_SHUTDOWN).broadcast(true).async(true).send();
        return this;
    }

    public Nano waitForStop() {
        NanoUtils.waitForCondition(() -> !this.isReady(), 10000L);
        return this;
    }

    public void printParameters() {
        if (this.context.asBooleanOpt(new Object[]{Context.APP_PARAMS}).filter(printCalled -> printCalled).isPresent(new Object[0])) {
            List<String> secrets = List.of("secret", "token", "pass", "pwd", "bearer", "auth", "private", "ssn");
            int keyLength = this.context.keySet().stream().map(String::valueOf).mapToInt(String::length).max().orElse(0);
            this.context.info(() -> "Configs: " + System.lineSeparator() + this.context.entrySet().stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(String.valueOf(o1.getKey()), String.valueOf(o2.getKey()))).map(config -> String.format("%-" + keyLength + "s  %s", config.getKey(), secrets.stream().anyMatch(s -> String.valueOf(config.getKey()).toLowerCase().contains((CharSequence)s)) ? "****" : config.getValue())).collect(Collectors.joining(System.lineSeparator())), new Object[0]);
        }
    }

    @Override
    public Nano sendEvent(Event<?, ?> event) {
        this.sendEventR(event);
        return this;
    }

    @Override
    public <C, R> Event<C, R> sendEventR(Event<C, R> event) {
        if (!event.isAsync()) {
            this.sendEventSameThread(event);
        } else {
            this.context.run(() -> this.sendEventSameThread(event));
        }
        return event;
    }

    public Nano sendEventSameThread(Event<?, ?> event) {
        if (((Boolean)event.asBooleanOpt(new Object[]{"send"}).orElse((Object)false)).booleanValue()) {
            throw new IllegalStateException("Event already send. Channel [" + String.valueOf(event.channel()) + "] ack [" + String.valueOf(event.acknowledge()) + "]", event.error());
        }
        event.put("send", true);
        this.eventCount.incrementAndGet();
        event.context().tryExecute(() -> {
            boolean match = this.listeners.getOrDefault(event.channel().id(), Collections.emptySet()).stream().anyMatch(listener -> {
                event.context().tryExecute(() -> listener.accept(event), throwable -> event.context().sendEventError(event, (Throwable)throwable));
                return !event.isBroadcast() && event.isAcknowledged();
            });
            if (!match) {
                match = this.services.stream().filter(Service::isReady).anyMatch(service -> {
                    event.context().tryExecute(() -> service.receiveEvent(event), throwable -> event.context().sendEventError(event, (Service)service, (Throwable)throwable));
                    return !event.isBroadcast() && event.isAcknowledged();
                });
            }
            if (event.channel() == LogService.EVENT_LOGGING && !match) {
                this.logService.onEvent(event);
            }
        });
        this.eventCount.decrementAndGet();
        return this;
    }

    protected Nano shutdown(Class<?> clazz) {
        this.shutdown(this.context(clazz));
        return this;
    }

    protected void cleanUps(Event<?, ?> event) {
        double usage = this.heapMemoryUsage();
        int threshold = (Integer)this.context.asIntOpt(new Object[]{Context.CONFIG_OOM_SHUTDOWN_THRESHOLD}).orElse((Object)98);
        if (threshold > 0 && usage > (double)threshold / 100.0 && !this.context.newEvent(Context.EVENT_APP_OOM, () -> usage).send().isAcknowledged()) {
            this.context.warn(() -> "Out of mana aka memory [{}] threshold [{}] event [{}] shutting down", usage, threshold, Context.EVENT_APP_OOM.name());
            this.context.put("_app_exit_code", 127);
            this.shutdown(this.context);
        }
        new HashSet(this.schedulers).stream().filter(scheduler -> scheduler.isShutdown() || scheduler.isTerminated()).forEach(this.schedulers::remove);
    }

    protected void printActiveProfiles() {
        List list = this.context.asList(String.class, new Object[]{"_scanned_profiles"});
        if (!list.isEmpty()) {
            this.context.debug(() -> "Profiles [{}] Services [{}]", list.stream().sorted().collect(Collectors.joining(", ")), this.services().stream().collect(Collectors.groupingBy(Service::name, Collectors.counting())).entrySet().stream().map(entry -> (Long)entry.getValue() > 1L ? "(" + String.valueOf(entry.getValue()) + ") " + (String)entry.getKey() : (String)entry.getKey()).collect(Collectors.joining(", ")));
        }
    }

    protected void startServicesAndLogger(FunctionOrNull<Context, List<Service>> startupServices) {
        List services;
        block8: {
            block7: {
                if (startupServices == null) break block7;
                if (!this.services.stream().noneMatch(LogService.class::isInstance)) break block8;
            }
            this.context.newEvent(Context.EVENT_APP_SERVICE_REGISTER, () -> this.logService).broadcast(true).send();
        }
        if (startupServices != null && (services = (List)startupServices.apply((Object)this.context)) != null) {
            this.context.debug(() -> "Init [{}] services [{}]", services.size(), services.stream().map(Service::name).distinct().collect(Collectors.joining(", ")));
            this.context.runAwait((Service[])services.toArray(Service[]::new));
            while (!this.services.containsAll(services)) {
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected Nano shutdown(Context context) {
        if (this.isReady.compareAndSet(true, false)) {
            context.info(() -> "Stop {} ...", context.asString(new Object[]{"app_nano_name"}));
            int exitCode = (Integer)context.asIntOpt(new Object[]{"_app_exit_code"}).orElse((Object)0);
            boolean exitCodeAllowed = (Boolean)context.asBooleanOpt(new Object[]{Context.CONFIG_ENV_PROD}).orElse((Object)false);
            this.gracefulShutdown(context);
            if (exitCodeAllowed) {
                this.exit(context, exitCode);
            }
        }
        return this;
    }

    public Nano printSystemInfo() {
        long activeThreads = NanoThread.activeCarrierThreads();
        this.context.debug(() -> "pid [{}] schedulers [{}] services [{}] listeners [{}] cores [{}] usedMemory [{}mb] threadsNano [{}], threadsActive [{}] threadsOther [{}] java [{}] arch [{}] os [{}]", this.pid(), this.schedulers.size(), this.services.size(), this.listeners.values().stream().mapToLong(Collection::size).sum(), Runtime.getRuntime().availableProcessors(), this.usedMemoryMB(), NanoThread.activeNanoThreads(), activeThreads, (long)ManagementFactory.getThreadMXBean().getThreadCount() - activeThreads, System.getProperty("java.version"), System.getProperty("os.arch"), System.getProperty("os.name") + " - " + System.getProperty("os.version"));
        return this;
    }

    protected void gracefulShutdown(Context context) {
        try {
            Thread sequence = new Thread(() -> {
                long startTimeMs = System.nanoTime();
                context.debug(() -> "Shutdown Services count [{}] services [{}]", this.services.size(), this.services.stream().map(Object::getClass).map(Class::getSimpleName).distinct().collect(Collectors.joining(", ")));
                this.shutdownServices(this.context);
                this.shutdownThreads();
                this.listeners.clear();
                context.info(() -> "Stopped [{}] in [{}] with uptime [{}]", context.asString(new Object[]{"app_nano_name"}), NanoUtils.formatDuration(System.nanoTime() - startTimeMs), NanoUtils.formatDuration(System.nanoTime() - this.createdAtNs));
                this.schedulers.clear();
            }, Nano.class.getSimpleName() + " Shutdown-Hook");
            sequence.start();
            sequence.join();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected void exit(Context context, int exitCode) {
        try {
            Thread thread = new Thread(() -> {
                try {
                    Runtime.getRuntime().halt(exitCode);
                }
                catch (SecurityException e) {
                    context.error(e, () -> "Failed to set exit code. The dark side is strong.", new Object[0]);
                }
            }, Nano.class.getSimpleName() + " Shutdown-Thread");
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            context.error(e, () -> "Shutdown was interrupted. The empire strikes back.", new Object[0]);
        }
    }

    public String toString() {
        long activeThreads = NanoThread.activeCarrierThreads();
        return "Nano{pid=" + this.pid() + ", schedulers=" + this.schedulers.size() + ", services=" + this.services.size() + ", listeners=" + this.listeners.values().stream().mapToLong(Collection::size).sum() + ", cores=" + Runtime.getRuntime().availableProcessors() + ", usedMemory=" + this.usedMemoryMB() + "mb, threadsActive=" + NanoThread.activeNanoThreads() + ", threadsNano=" + activeThreads + ", threadsOther=" + ((long)ManagementFactory.getThreadMXBean().getThreadCount() - activeThreads) + ", java=" + System.getProperty("java.version") + ", arch=" + System.getProperty("os.arch") + ", os=" + System.getProperty("os.name") + " - " + System.getProperty("os.version") + "}";
    }
}

