/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.http;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.InetSocketAddress;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.nanonative.nano.core.model.Context;
import org.nanonative.nano.services.http.HttpServer;

public class HttpsHelper {
    public static final String TYPE_PKCS_12 = "PKCS12";
    public static final String TYPE_JCEKS = "JCEKS";
    public static final String TYPE_JKS = "JKS";
    public static final String TYPE_TLS = "TLS";
    public static final String TYPE_X_509 = "X.509";

    public static com.sun.net.httpserver.HttpServer createDefaultServer(Context context) throws IOException {
        int preferredPort = (Integer)context.asIntOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTP_PORT}).orElse((Object)8080);
        try {
            com.sun.net.httpserver.HttpServer server = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(preferredPort), 0);
            context.put(HttpServer.CONFIG_SERVICE_HTTP_PORT, server.getAddress().getPort());
            return server;
        }
        catch (IOException ignored) {
            com.sun.net.httpserver.HttpServer fallback = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(0), 0);
            context.put(HttpServer.CONFIG_SERVICE_HTTP_PORT, fallback.getAddress().getPort());
            return fallback;
        }
    }

    public static com.sun.net.httpserver.HttpServer createHttpsServer(Context context) throws IOException {
        int preferredPort = (Integer)context.asIntOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTP_PORT}).orElse((Object)8443);
        try {
            HttpsServer server = HttpsServer.create(new InetSocketAddress(preferredPort), 0);
            context.put(HttpServer.CONFIG_SERVICE_HTTP_PORT, server.getAddress().getPort());
            return server;
        }
        catch (IOException ignored) {
            HttpsServer fallback = HttpsServer.create(new InetSocketAddress(0), 0);
            context.put(HttpServer.CONFIG_SERVICE_HTTP_PORT, fallback.getAddress().getPort());
            return fallback;
        }
    }

    public static void configureHttps(Context context, com.sun.net.httpserver.HttpServer server) {
        if (server instanceof HttpsServer) {
            HttpsServer httpsServer = (HttpsServer)server;
            char[] password = (char[])context.asStringOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTPS_PASSWORD}).map(String::toCharArray).orElse(null);
            try {
                String ktsType = (String)context.asPathOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTPS_KTS}).map(Path::toString).map(String::toLowerCase).map(file -> {
                    if (file.endsWith(".jks")) {
                        return TYPE_JKS;
                    }
                    if (file.endsWith(".jceks")) {
                        return TYPE_JCEKS;
                    }
                    if (file.endsWith(".p12") || file.endsWith(".pfx")) {
                        return TYPE_PKCS_12;
                    }
                    return TYPE_PKCS_12;
                }).orElse((Object)TYPE_PKCS_12);
                KeyStore keyStore = KeyStore.getInstance(ktsType);
                keyStore.load(null, password);
                Certificate cert = HttpsHelper.readCertificate(context, keyStore);
                HttpsHelper.readKey(context, keyStore, password, cert);
                HttpsHelper.readKts(context, password, keyStore, ktsType);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, password);
                SSLContext sslContext = SSLContext.getInstance(TYPE_TLS);
                sslContext.init(kmf.getKeyManagers(), null, null);
                httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext));
                context.info(() -> "HTTPS configured on port [%s] with keystore [%s]", context.asInt(new Object[]{HttpServer.CONFIG_SERVICE_HTTP_PORT}), ktsType);
            }
            catch (Exception e) {
                context.error(() -> "Failed to configure HTTPS", e);
            }
        }
    }

    public static void readKey(Context context, KeyStore keyStore, char[] password, Certificate cert) {
        context.asPathOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTPS_KEY}).ifPresent(file -> {
            Path keyFile = file;
            Path tempFile = null;
            if (HttpsHelper.isConversionNeeded(file)) {
                keyFile = tempFile = HttpsHelper.convertKeyToPkcs8(context, file, password != null ? new String(password) : null);
            }
            byte[] keyBytes23333332 = Files.readAllBytes(keyFile);
            byte[] decodedKey = Base64.getDecoder().decode(new String(keyBytes23333332).replaceAll("-----.*?-----", "").replaceAll("\\s", ""));
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decodedKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = kf.generatePrivate(spec);
            keyStore.setKeyEntry(file.getFileName().toString(), privateKey, password, new Certificate[]{cert});
            if (tempFile == null) return;
            try {
                Files.deleteIfExists(tempFile);
                return;
            }
            catch (IOException keyBytes23333332) {}
            return;
            catch (InterruptedException ignored2222222) {
                Thread.currentThread().interrupt();
                if (tempFile == null) return;
                try {
                    Files.deleteIfExists(tempFile);
                    return;
                }
                catch (IOException ignored2222222) {}
                return;
            }
            catch (Exception e) {
                context.error(e, () -> "Failed to load private key [%s]", file);
                throw new IllegalArgumentException("Failed to load private key [" + String.valueOf(file) + "]", e);
                {
                    catch (Throwable throwable) {
                        if (tempFile == null) throw throwable;
                        try {
                            Files.deleteIfExists(tempFile);
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        });
    }

    public static Certificate readCertificate(Context context, KeyStore keyStore) {
        return (Certificate)context.asPathOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTPS_CERT}).map(file -> {
            Certificate certificate;
            block8: {
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    Certificate certificate2 = CertificateFactory.getInstance(TYPE_X_509).generateCertificate(is);
                    keyStore.setCertificateEntry(file.getFileName().toString(), certificate2);
                    certificate = certificate2;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        context.error(e, () -> "Failed to load X.509 file [%s]", file);
                        return null;
                    }
                }
                is.close();
            }
            return certificate;
        }).orElse(null);
    }

    public static void readKts(Context context, char[] password, KeyStore keyStore, String ktsType) {
        context.asPathOpt(new Object[]{HttpServer.CONFIG_SERVICE_HTTPS_KTS}).ifPresent(file -> {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                KeyStore store = KeyStore.getInstance(ktsType);
                store.load(is, password);
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    PrivateKey key = (PrivateKey)store.getKey(alias, password);
                    Certificate[] chain = store.getCertificateChain(alias);
                    if (key == null || chain == null) continue;
                    keyStore.setKeyEntry(alias, key, password, chain);
                }
            }
            catch (Exception e) {
                context.error(e, () -> "Failed to load keystore file [%s]", file);
            }
        });
    }

    public static List<Path> findDefaultLinuxCaBundle() {
        List<CallSite> candidates = List.of("/etc/ssl/certs/ca-certificates.crt", "/etc/pki/tls/certs/ca-bundle.crt", "/etc/ssl/ca-bundle.pem", System.getProperty("java.home") + "/lib/security/cacerts");
        return candidates.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
    }

    public static SSLContext createTrustedSslContext() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance(TYPE_TLS);
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build trust-all HttpClient", e);
        }
    }

    public static SSLContext createCustomTrustedSslContext(Context context, List<Path> paths) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            CertificateFactory cf = CertificateFactory.getInstance(TYPE_X_509);
            AtomicInteger loadedCerts = new AtomicInteger(0);
            paths.stream().filter(Objects::nonNull).flatMap(HttpsHelper::toFiles).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(p -> {
                String name = p.getFileName().toString().toLowerCase();
                return name.endsWith(".crt") || name.endsWith(".pem") || name.endsWith(".cer") || name.endsWith(".der");
            }).forEach(certPath -> {
                try (InputStream in = Files.newInputStream(certPath, new OpenOption[0]);){
                    cf.generateCertificates(in).forEach(cert -> {
                        try {
                            trustStore.setCertificateEntry("cert-" + loadedCerts.getAndIncrement(), (Certificate)cert);
                        }
                        catch (Exception e) {
                            context.error(() -> "Skipping invalid cert file [%s] message [%s]", certPath, e.getMessage());
                        }
                    });
                }
                catch (Exception ignored) {
                    context.debug(() -> "Skipping invalid cert file {" + String.valueOf(certPath) + "]", new Object[0]);
                }
            });
            if (loadedCerts.get() == 0) {
                throw new IllegalArgumentException("No valid certificates found in " + String.valueOf(paths));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(TYPE_TLS);
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create SSLContext from trusted certs " + String.valueOf(paths), e);
        }
    }

    private static Stream<Path> toFiles(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> stream;
            block9: {
                Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
                try {
                    stream = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList().stream();
                    if (walk == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walk != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return Stream.empty();
                    }
                }
                walk.close();
            }
            return stream;
        }
        return Stream.of(path).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    private static boolean isConversionNeeded(Path file) {
        try {
            String content = Files.readString(file);
            return content.contains("-----BEGIN RSA PRIVATE KEY-----") || content.contains("-----BEGIN ENCRYPTED PRIVATE KEY-----");
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static Path convertKeyToPkcs8(Context context, Path originalKeyPath, String password) throws IOException, InterruptedException {
        Path tempPkcs8 = Files.createTempFile("converted", ".key", new FileAttribute[0]);
        ProcessBuilder pb = new ProcessBuilder("openssl", "pkcs8", "-topk8", "-inform", "PEM", "-in", originalKeyPath.toAbsolutePath().toString(), "-out", tempPkcs8.toAbsolutePath().toString(), "-nocrypt");
        if (password != null) {
            pb.command().add("-passin");
            pb.command().add("pass:" + password);
        }
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException("OpenSSL key conversion failed, exit code: " + exitCode + "\nOutput:\n" + String.valueOf(output) + "\nCommand: " + String.join((CharSequence)" ", pb.command()));
        }
        context.info(() -> "Converted key to PKCS#8: " + String.valueOf(tempPkcs8), new Object[0]);
        return tempPkcs8;
    }

    private HttpsHelper() {
    }
}

