/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.helper.event.model;

import berlin.yuna.typemap.model.LinkedTypeMap;
import java.util.Optional;
import org.nanonative.nano.core.NanoBase;
import org.nanonative.nano.helper.NanoUtils;

public record Channel<T, R>(int id, String name, Class<T> payload, Class<R> response) {
    public static Channel<Void, Void> registerChannelId(String name) {
        return Channel.registerChannelId(name, Void.class, Void.class);
    }

    public static <C> Channel<C, Void> registerChannelId(String name, Class<C> payload) {
        return Channel.registerChannelId(name, payload, Void.class);
    }

    public static <C, R> Channel<C, R> registerChannelId(String name, Class<C> type, Class<R> response) {
        return Optional.ofNullable(name).filter(NanoUtils::hasText).map(nme -> Channel.channelOf(nme).orElseGet(() -> {
            Channel channel = new Channel(NanoBase.EVENT_ID_COUNTER.incrementAndGet(), (String)nme, type, response);
            NanoBase.EVENT_CHANNELS.put(channel.id(), channel);
            return channel;
        })).orElse(null);
    }

    public static Optional<Channel<?, ?>> channelOf(String name) {
        return !NanoUtils.hasText(name) ? Optional.empty() : NanoBase.EVENT_CHANNELS.values().stream().filter(channel -> channel.name().equals(name)).findFirst();
    }

    public static Channel<?, ?> channelOf(int id) {
        return NanoBase.EVENT_CHANNELS.get(id);
    }

    public static boolean isChannelIdAvailable(int id) {
        return NanoBase.EVENT_CHANNELS.containsKey(id);
    }

    @Override
    public String toString() {
        return ((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)((LinkedTypeMap)new LinkedTypeMap().putR((Object)"id", (Object)this.id)).putR((Object)"name", (Object)this.name)).putR((Object)"class", (Object)this.getClass().getSimpleName())).putR((Object)"type", (Object)this.payload.getSimpleName())).toJson();
    }
}

