/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import org.nanonative.nano.services.logging.LogFormatterConsole;
import org.nanonative.nano.services.logging.LogFormatterJson;

public class LogFormatRegister {
    public static final Map<String, Formatter> LOG_FORMATTERS = new ConcurrentHashMap<String, Formatter>();

    public static void registerLogFormatter(String id, Formatter formatter) {
        LOG_FORMATTERS.put(id, formatter);
    }

    public static Formatter getLogFormatter(String id) {
        if ("console".equals(id)) {
            return LogFormatRegister.getLogFormatter(id, LogFormatterConsole::new);
        }
        if ("json".equals(id)) {
            return LogFormatRegister.getLogFormatter(id, LogFormatterJson::new);
        }
        return LogFormatRegister.getLogFormatter(id, LogFormatterConsole::new);
    }

    public static Formatter getLogFormatter(String id, Supplier<Formatter> orRegister) {
        return LOG_FORMATTERS.computeIfAbsent(id, formatter -> (Formatter)orRegister.get());
    }

    private LogFormatRegister() {
    }
}

