/*
 * Decompiled with CFR 0.152.
 */
package org.nanonative.nano.services.logging;

import berlin.yuna.typemap.logic.TypeConverter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.nanonative.nano.helper.NanoUtils;
import org.nanonative.nano.services.logging.LogFormatterConsole;
import org.nanonative.nano.services.logging.model.LogLevel;

public class LogFormatterJson
extends Formatter {
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final Pattern MESSAGE_KEY_VALUE_PATTERN = Pattern.compile("(\\w+):?\\s*\\[\\{\\}]");

    @Override
    public String format(LogRecord logRecord) {
        Object[] params = logRecord.getParameters();
        TreeMap<String, String> jsonMap = new TreeMap<String, String>();
        String message = LogFormatterConsole.applyCustomFormat(logRecord.getMessage(), params);
        int dot = logRecord.getLoggerName().lastIndexOf(".");
        this.extractKeyValuesFromMessage(jsonMap, logRecord.getMessage(), params);
        this.addJsonEntries(jsonMap, params);
        this.putEntry(jsonMap, "message", message);
        this.putEntry(jsonMap, "timestamp", this.dateFormat.format(new Date(logRecord.getMillis())));
        this.putEntry(jsonMap, "level", (Object)LogLevel.nanoLogLevelOf(logRecord.getLevel()));
        this.putEntry(jsonMap, "package", dot != -1 ? logRecord.getLoggerName().substring(0, dot) : "");
        this.putEntry(jsonMap, "logger", dot != -1 ? logRecord.getLoggerName().substring(dot + 1) : logRecord.getLoggerName());
        if (logRecord.getThrown() != null) {
            this.putEntry(jsonMap, "error", this.jsonEscape(TypeConverter.convertObj((Object)logRecord.getThrown(), String.class)));
        }
        return "{" + jsonMap.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\":\"" + (String)entry.getValue() + "\"").collect(Collectors.joining(",")) + "}" + NanoUtils.LINE_SEPARATOR;
    }

    protected void extractKeyValuesFromMessage(Map<String, String> jsonMap, String message, Object[] params) {
        Matcher matcher = MESSAGE_KEY_VALUE_PATTERN.matcher(message);
        for (int index = 0; matcher.find() && params != null && index < params.length; ++index) {
            this.putEntry(jsonMap, matcher.group(1), params[index]);
        }
    }

    protected void addJsonEntries(Map<String, String> jsonMap, Object[] params) {
        if (params != null) {
            for (Object param : params) {
                if (!(param instanceof Map)) continue;
                Map map = (Map)param;
                for (Map.Entry entry : map.entrySet()) {
                    this.putEntry(jsonMap, entry.getKey(), entry.getValue());
                }
            }
        }
    }

    protected void putEntry(Map<String, String> jsonMap, Object key, Object value) {
        jsonMap.put(this.jsonEscape(TypeConverter.convertObj((Object)key, String.class)), this.jsonEscape(TypeConverter.convertObj((Object)value, String.class)));
    }

    protected String jsonEscape(Object value) {
        if (value == null) {
            return null;
        }
        String strValue = value.toString();
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < strValue.length(); ++i) {
            char c = strValue.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

