/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.cli;

import com.github.jelmerk.hnswlib.core.DistanceFunction;
import com.github.jelmerk.hnswlib.core.Item;
import com.github.jelmerk.hnswlib.core.ProgressListener;
import com.github.jelmerk.hnswlib.core.hnsw.HnswIndex;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import org.nasdanika.common.Description;
import picocli.CommandLine;

public abstract class HnswIndexBuilderArgGroup<TVector, TDistance extends Comparable<TDistance>> {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    @CommandLine.Option(names={"--hnsw-ef"}, description={"Size of the dynamic list for the nearest neighbors", "Default value: ${DEFAULT-VALUE}"}, defaultValue="200")
    @Description(value="The size of the dynamic list for the nearest neighbors (used during the search).\nHigher ``ef`` leads to more accurate but slower search.\nThe value ef of can be anything between ``k`` (number of items to return from search) and the size of the dataset.\n\n[^ef-javadoc]: [ef javadoc](https://javadoc.io/static/com.github.jelmerk/hnswlib-core/1.2.0/com/github/jelmerk/hnswlib/core/hnsw/HnswIndex.BuilderBase.html#withEf(int))\n")
    protected int ef;
    @CommandLine.Option(names={"--hnsw-ef-contruction"}, description={"Controls the index time / index precision", "Default value: ${DEFAULT-VALUE}"}, defaultValue="200")
    @Description(value="The option has the same meaning as ``--hnsw-ef``, but controls the index time / index precision.\nBigger ``ef-construction`` leads to longer construction, but better index quality.\nAt some point, increasing ``ef-construction`` does not improve the quality of the index.\nOne way to check if the selection of ``ef-construction`` was ok is to measure a recall for\n``M`` nearest neighbor search when ``ef = ef-construction``: if the recall is lower than ``0.9``,\nthen there is room for improvement.\n\n[^ef-construction-javadoc]: [ef-construction javadoc](https://javadoc.io/static/com.github.jelmerk/hnswlib-core/1.2.0/com/github/jelmerk/hnswlib/core/hnsw/HnswIndex.BuilderBase.html#withEfConstruction(int))\n")
    protected int efConstruction;
    @CommandLine.Option(names={"--hnsw-m"}, description={"The number of bi-directional links created", "for every new element during construction", "Default value: ${DEFAULT-VALUE}"}, defaultValue="16")
    @Description(value="Sets the number of bi-directional links created for every new element during construction.\nReasonable range for m is ``2-100``. Higher m work better on datasets with high intrinsic dimensionality and/or high recall,\nwhile low m work better for datasets with low intrinsic dimensionality and/or low recalls.\nThe parameter also determines the algorithm's memory consumption.\nAs an example for ``d = 4`` random vectors optimal ``m`` for search is somewhere around ``6``,\nwhile for high dimensional datasets (word embeddings, good face descriptors),\nhigher ``m`` are required (e.g. ``m = 48, 64``) for optimal\tperformance at high recall.\nThe range ``m = 12-48`` is ok for the most of the use cases.\nWhen ``m`` is changed one has to update the other parameters.\nNonetheless, ``ef`` and ``efConstruction`` parameters can be roughly estimated by\nassuming that ``m``  ``efConstruction`` is a constant[^m-javadoc].\n\n[^m-javadoc]: [m javadoc](https://javadoc.io/static/com.github.jelmerk/hnswlib-core/1.2.0/com/github/jelmerk/hnswlib/core/hnsw/HnswIndex.BuilderBase.html#withM(int))\n")
    protected int m;
    @CommandLine.Option(names={"--hnsw-remove-enabled"}, description={"If true, removal from the index is enabled"})
    protected boolean removeEnabled;
    @CommandLine.Option(names={"--hnsw-threads"}, description={"Number of threads to use for parallel indexing", "Default to the number of available processors"})
    private int threads = AVAILABLE_PROCESSORS;
    @CommandLine.Option(names={"--hnsw-progress-update-interval"}, description={"After indexing this many items progress will be", "reported. The last element will always be", "reported regardless of this setting. ", "Default value: 100000"})
    private int progressUpdateInterval = 100000;

    public HnswIndex.Builder<TVector, TDistance> createIndexBuilder(int dimensions, int maxItemCount) {
        HnswIndex.Builder builder = (HnswIndex.Builder)((HnswIndex.Builder)((HnswIndex.Builder)HnswIndex.newBuilder((int)dimensions, this.getDistanceFunction(), (int)maxItemCount).withM(this.m)).withEf(this.ef)).withEfConstruction(this.efConstruction);
        if (this.removeEnabled) {
            builder.withRemoveEnabled();
        }
        return builder;
    }

    protected abstract DistanceFunction<TVector, TDistance> getDistanceFunction();

    public void setSpanAttributes(Span span) {
        span.setAttribute("hnsw.ef", (long)this.ef);
        span.setAttribute("hnsw.ef-construction", (long)this.efConstruction);
        span.setAttribute("hnsw.m", (long)this.m);
        span.setAttribute("hnsw.remove-enabled", this.removeEnabled);
    }

    public <TId, TItem extends Item<TId, TVector>> HnswIndex<TId, TVector, TItem, TDistance> buildAndAddAll(int dimensions, Collection<TItem> items, Span span) throws InterruptedException {
        HnswIndex index = this.createIndexBuilder(dimensions, items.size()).build();
        ProgressListener progressListener = (workDone, max) -> {
            AttributesBuilder ab = Attributes.builder();
            ab.put("done", (long)workDone);
            ab.put("total", (long)max);
            ab.put("percent", 100L * (long)workDone / (long)max);
            span.addEvent("hnsw.progress", ab.build());
        };
        index.addAll(items, this.threads, progressListener, this.progressUpdateInterval);
        return index;
    }
}

