/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.cli;

import com.github.jelmerk.hnswlib.core.DistanceFunction;
import com.github.jelmerk.hnswlib.core.DistanceFunctions;
import com.github.jelmerk.hnswlib.util.VectorUtils;
import io.opentelemetry.api.trace.Span;
import org.nasdanika.ai.cli.HnswIndexBuilderArgGroup;
import picocli.CommandLine;

public class HnswIndexBuilderFloatArgGroup
extends HnswIndexBuilderArgGroup<float[], Float> {
    @CommandLine.Option(names={"--hnsw-distance-function"}, description={"Vector distance function", "Valid values: ${COMPLETION-CANDIDATES}", "Default value: COSINE"})
    protected Distance distanceFunction = Distance.COSINE;
    @CommandLine.Option(names={"--hnsw-normalize"}, description={"If true, vectors are normalized"})
    protected boolean normalize;

    @Override
    protected DistanceFunction<float[], Float> getDistanceFunction() {
        return this.distanceFunction.distanceFunction;
    }

    public float[] normalize(float[] vector) {
        return this.normalize ? VectorUtils.normalize((float[])vector) : vector;
    }

    @Override
    public void setSpanAttributes(Span span) {
        span.setAttribute("hnsw.distance-function", this.distanceFunction.name());
        span.setAttribute("hnsw.normalize", this.normalize);
    }

    public static enum Distance {
        BRAY_CURTIS((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_BRAY_CURTIS_DISTANCE),
        CANBERRA((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_CANBERRA_DISTANCE),
        CORRELATION((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_CORRELATION_DISTANCE),
        COSINE((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_COSINE_DISTANCE),
        EUCLIDEAN((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_EUCLIDEAN_DISTANCE),
        INNER_PRODUCT((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_INNER_PRODUCT),
        MANHATTAN((DistanceFunction<float[], Float>)DistanceFunctions.FLOAT_MANHATTAN_DISTANCE);

        public final DistanceFunction<float[], Float> distanceFunction;

        private Distance(DistanceFunction<float[], Float> distanceFunction) {
            this.distanceFunction = distanceFunction;
        }
    }
}

