/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Arrays;
import java.util.function.Function;
import org.nasdanika.ai.AbstractDoubleFitter;

public abstract class AbstractRecursiveDoubleFitter
extends AbstractDoubleFitter {
    @Override
    protected final Function<double[][], double[][]> fit(double[][] features, double[][] labels) {
        Function[] predictors = new Function[labels[0].length];
        for (int i = 0; i < predictors.length; ++i) {
            double[] pLabels = new double[labels.length];
            double[][] pFeatures = new double[features.length][];
            for (int j = 0; j < labels.length; ++j) {
                pLabels[j] = labels[j][i];
                if (i == 0) {
                    pFeatures[j] = features[j];
                    continue;
                }
                pFeatures[j] = Arrays.copyOf(features[j], features[j].length + i);
                System.arraycopy(labels[j], 0, pFeatures[j], features[j].length, i);
            }
            predictors[i] = this.fit((double[][])pFeatures, pLabels);
        }
        return input -> {
            int j;
            double[][] predictions = new double[predictors.length][];
            for (int i = 0; i < predictors.length; ++i) {
                if (i == 0) {
                    predictions[i] = (double[])predictors[i].apply(input);
                    continue;
                }
                double[][] pInput = new double[((double[][])input).length][];
                for (j = 0; j < ((double[][])input).length; ++j) {
                    pInput[j] = Arrays.copyOf(input[j], input[j].length + i);
                    for (int k = 0; k < i; ++k) {
                        pInput[j][input[j].length + k] = predictions[k][j];
                    }
                }
                predictions[i] = (double[])predictors[i].apply(pInput);
            }
            double[][] output = new double[((double[][])input).length][predictors.length];
            for (int i = 0; i < output.length; ++i) {
                for (j = 0; j < predictors.length; ++j) {
                    output[i][j] = predictions[j][i];
                }
            }
            return output;
        };
    }

    protected abstract Function<double[][], double[]> fit(double[][] var1, double[] var2);
}

