/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.nasdanika.ai.Model;
import reactor.core.publisher.Mono;

public interface Chat
extends Model {
    public static final Chat ECHO = new Chat(){

        @Override
        public int getMaxInputTokens() {
            return Integer.MAX_VALUE;
        }

        @Override
        public String getProvider() {
            return "Nasdanika";
        }

        @Override
        public String getName() {
            return "Echo";
        }

        @Override
        public String getVersion() {
            Optional<ModuleDescriptor.Version> moduleVersion = this.getClass().getModule().getDescriptor().version();
            return moduleVersion == null ? new Date().toString() : moduleVersion.toString();
        }

        @Override
        public Mono<List<? extends ResponseMessage>> chatAsync(List<Message> messages) {
            List<1> responseMessages = messages.stream().map(m -> new ResponseMessage(){
                final /* synthetic */ Message val$m;
                {
                    this.val$m = message;
                }

                @Override
                public String getRole() {
                    return Role.assistant.name();
                }

                @Override
                public String getContent() {
                    return this.val$m.getContent();
                }

                @Override
                public String getRefusal() {
                    return null;
                }

                @Override
                public String getFinishReason() {
                    return "stop";
                }
            }).toList();
            Mono mono = Mono.just(responseMessages);
            return mono.delayElement(Duration.ofSeconds(1L));
        }

        @Override
        public int getMaxOutputTokens() {
            return Integer.MAX_VALUE;
        }
    };
    public static final String LOREM_IPSUM_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec tempus ac nibh a convallis.\nPhasellus tristique, ex ac maximus iaculis, nulla magna aliquam turpis, a vestibulum ligula metus varius lectus.\nDuis rhoncus suscipit odio, vel porttitor metus egestas quis. Nunc quis tristique orci.\nPhasellus tellus mi, pellentesque id aliquam a, eleifend nec nunc. Curabitur volutpat feugiat vestibulum. Maecenas sit amet dapibus velit.\nFusce scelerisque, nisl a fermentum vulputate, nisi enim hendrerit orci, a vestibulum sem leo at lacus. Duis vel rhoncus odio.\nNam facilisis est in ullamcorper consectetur. Donec aliquet velit quis dolor accumsan maximus. Aenean sodales mattis sem sed tincidunt.\nAliquam tristique augue nec tristique lobortis. Vivamus id metus in justo dignissim viverra.\nPellentesque ipsum lectus, ultricies in vehicula efficitur, aliquam vel purus.\nPellentesque lacus metus, vestibulum at convallis non, sodales sed ante.\n\nDonec tincidunt elit eros, sit amet blandit ex posuere sed.\nPellentesque pharetra magna lacus, rhoncus placerat risus faucibus id. Duis non euismod turpis.\nVestibulum interdum dictum velit sit amet sagittis. Proin velit eros, interdum a nibh sed, viverra luctus ex.\nInteger commodo diam id arcu varius pharetra. Proin porta justo lorem, quis sodales ex fermentum a.\nSed at consequat dolor. In quis consectetur leo, non aliquet mauris.\n\nAenean laoreet dui a facilisis efficitur. Maecenas consectetur ligula non magna porta congue. Etiam a ornare lectus.\nNulla at ligula et tortor mattis bibendum id quis sapien. Aenean eget condimentum enim.\nDuis ullamcorper malesuada sapien et egestas. In hac habitasse platea dictumst. Quisque sed fermentum tortor. In vehicula auctor felis.\nDonec fringilla turpis eget tortor lobortis posuere quis ac erat. Morbi mattis elementum felis, sit amet scelerisque lectus finibus a.\nDonec ac est odio. Sed sollicitudin, arcu sit amet pulvinar pulvinar, lorem nisl malesuada odio, nec dapibus metus dui porta urna.\nIn viverra rhoncus est, sed interdum elit faucibus placerat. Proin ut ligula venenatis, bibendum massa in, fermentum sapien.\nMauris tempor eros ligula, id placerat eros vulputate quis.\n\nVestibulum quis dignissim urna. Pellentesque eros turpis, laoreet vel justo vel, tincidunt suscipit elit. Nullam eget cursus nulla.\nNulla pellentesque molestie sem, sed dictum lacus efficitur eu. Quisque orci lectus, egestas eget nunc quis, placerat blandit ligula.\nCras quis dictum sapien. Duis varius metus sapien, quis venenatis lectus dapibus ac. Sed eget sem ac leo elementum rhoncus.\nNunc dolor eros, dapibus a porta eget, vestibulum vel nunc. Aliquam erat volutpat. Nam imperdiet libero velit, vel ullamcorper nisi lacinia nec.\nSuspendisse blandit dolor ut odio aliquam sodales.\n\nIn nec augue pulvinar, semper felis fringilla, vehicula dui.\nPraesent vulputate tellus ac ante varius, sit amet ultricies felis ultrices. Pellentesque egestas lectus non nibh viverra, vitae tristique orci ultrices.\nDonec non sem imperdiet neque varius sodales ut ut odio. Sed vehicula pellentesque nulla, ut dignissim turpis blandit non. Donec fermentum pellentesque nisi in facilisis.\nAenean mollis purus vel ex porttitor, sed bibendum ante mollis. Fusce molestie justo turpis, luctus sollicitudin augue pulvinar quis.\nNunc id tincidunt erat. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.\nCras accumsan laoreet velit. Vestibulum sit amet nisl mauris.\n";
    public static final Chat LOREM_IPSUM = new Chat(){

        @Override
        public int getMaxInputTokens() {
            return Integer.MAX_VALUE;
        }

        @Override
        public String getProvider() {
            return "Nasdanika";
        }

        @Override
        public String getName() {
            return "Lorem Impsum";
        }

        @Override
        public String getVersion() {
            Optional<ModuleDescriptor.Version> moduleVersion = this.getClass().getModule().getDescriptor().version();
            return moduleVersion == null ? new Date().toString() : moduleVersion.toString();
        }

        @Override
        public Mono<List<? extends ResponseMessage>> chatAsync(List<Message> messages) {
            Mono ret = Mono.just(List.of(new ResponseMessage(this){

                @Override
                public String getRole() {
                    return Role.assistant.name();
                }

                @Override
                public String getContent() {
                    return Chat.LOREM_IPSUM_TEXT;
                }

                @Override
                public String getRefusal() {
                    return null;
                }

                @Override
                public String getFinishReason() {
                    return "stop";
                }
            }));
            return ret.delayElement(Duration.ofSeconds(1L));
        }

        @Override
        public int getMaxOutputTokens() {
            return Integer.MAX_VALUE;
        }
    };

    public Mono<List<? extends ResponseMessage>> chatAsync(List<Message> var1);

    default public Mono<List<? extends ResponseMessage>> chatAsync(Message ... messages) {
        return this.chatAsync(Arrays.asList(messages));
    }

    default public List<? extends ResponseMessage> chat(List<Message> messages) {
        return (List)this.chatAsync(messages).block();
    }

    default public List<? extends ResponseMessage> chat(Message ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    public int getMaxOutputTokens();

    public static enum Role {
        system,
        assistant,
        user,
        function,
        tool,
        developer;


        public Message createMessage(String content) {
            return Message.create(this.name(), content);
        }
    }

    public static interface ResponseMessage
    extends Message {
        public String getRefusal();

        public String getFinishReason();

        @Override
        default public Message addImage(String dataUrl) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public List<String> getImages() {
            return Collections.emptyList();
        }
    }

    public static interface Message {
        public String getRole();

        public String getContent();

        public List<String> getImages();

        public Message addImage(String var1);

        default public Message addImage(File file) {
            try {
                return this.addImage(ImageIO.read(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from file '" + file.getAbsolutePath() + "': " + String.valueOf(e), e);
            }
        }

        default public Message addImage(InputStream inputStream) {
            try {
                return this.addImage(ImageIO.read(inputStream));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from input stream: " + String.valueOf(e), e);
            }
        }

        default public Message addImage(URL url) {
            try {
                return this.addImage(ImageIO.read(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from URL '" + String.valueOf(url) + "': " + String.valueOf(e), e);
            }
        }

        default public Message addImage(BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                try (ByteArrayOutputStream byteArrayOutputStream = baos;){
                    ImageIO.write((RenderedImage)image, "PNG", baos);
                }
                String base64Image = Base64.getEncoder().encodeToString(baos.toByteArray());
                return this.addImage("data:image/png;base64," + base64Image);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot write image: " + String.valueOf(e), e);
            }
        }

        public static Message create(final String role, final String content) {
            return new Message(){
                private List<String> images = new ArrayList<String>();

                @Override
                public String getRole() {
                    return role;
                }

                @Override
                public String getContent() {
                    return content;
                }

                @Override
                public List<String> getImages() {
                    return Collections.unmodifiableList(this.images);
                }

                @Override
                public Message addImage(String dataUrl) {
                    this.images.add(dataUrl);
                    return this;
                }
            };
        }
    }

    public record Requirement(String provider, String model, String version) {
    }
}

