/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.nasdanika.common.Composable;
import reactor.core.publisher.Mono;

public interface EmbeddingGenerator<S, E>
extends Composable<EmbeddingGenerator<S, E>> {
    default public E generate(S input) {
        return (E)this.generateAsync(input).block();
    }

    public Mono<E> generateAsync(S var1);

    default public Map<S, E> generate(Collection<S> input) {
        return (Map)this.generateAsync(input).block();
    }

    default public Mono<Map<S, E>> generateAsync(Collection<S> input) {
        List<Mono> monos = input.stream().map(ie -> {
            Mono<E> embMono = this.generateAsync(ie);
            return embMono.map(emb -> Map.entry(ie, emb));
        }).toList();
        return Mono.zip(monos, this::combine);
    }

    private Map<S, E> combine(Object[] elements) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Object el : elements) {
            Map.Entry e = (Map.Entry)el;
            ret.put(e.getKey(), e.getValue());
        }
        return ret;
    }

    default public <F> EmbeddingGenerator<S, F> then(final EmbeddingGenerator<E, F> next) {
        return new EmbeddingGenerator<S, F>(){

            @Override
            public Mono<F> generateAsync(S source) {
                return EmbeddingGenerator.this.generateAsync(source).flatMap(next::generateAsync);
            }

            @Override
            public F generate(S input) {
                return next.generate(EmbeddingGenerator.this.generate(input));
            }
        };
    }

    default public <V> EmbeddingGenerator<V, E> adapt(final Function<V, Mono<S>> mapper) {
        return new EmbeddingGenerator<V, E>(){

            @Override
            public Mono<E> generateAsync(V source) {
                return ((Mono)mapper.apply(source)).flatMap(EmbeddingGenerator.this::generateAsync);
            }
        };
    }

    default public EmbeddingGenerator<S, E> compose(final EmbeddingGenerator<? super S, ? extends E> other, final BinaryOperator<E> composer) {
        if (other == null) {
            return this;
        }
        return new EmbeddingGenerator<S, E>(){

            @Override
            public Mono<E> generateAsync(S input) {
                Mono thisResult = EmbeddingGenerator.this.generateAsync(input);
                if (composer == null) {
                    return thisResult.switchIfEmpty(other.generateAsync(input));
                }
                Mono otherResult = other.generateAsync(input);
                Function<Object, Mono> transformer = a -> otherResult.map(b -> composer.apply(a, b)).defaultIfEmpty(a);
                return thisResult.flatMap(transformer).switchIfEmpty(otherResult);
            }

            @Override
            public E generate(S input) {
                Object thisResult = EmbeddingGenerator.this.generate(input);
                if (composer == null) {
                    return thisResult == null ? other.generate(input) : thisResult;
                }
                return composer.apply(thisResult, other.generate(input));
            }
        };
    }

    default public EmbeddingGenerator<S, E> composeAsync(final EmbeddingGenerator<? super S, ? extends E> other, final BiFunction<? super E, ? super E, Mono<E>> composer) {
        if (other == null) {
            return this;
        }
        return new EmbeddingGenerator<S, E>(){

            @Override
            public Mono<E> generateAsync(S input) {
                Mono thisResult = EmbeddingGenerator.this.generateAsync(input);
                if (composer == null) {
                    return thisResult.switchIfEmpty(other.generateAsync(input));
                }
                Mono otherResult = other.generateAsync(input);
                Function<Object, Mono> transformer = a -> otherResult.flatMap(b -> (Mono)composer.apply(a, b)).defaultIfEmpty(a);
                return thisResult.flatMap(transformer).switchIfEmpty(otherResult);
            }
        };
    }

    default public EmbeddingGenerator<S, E> compose(EmbeddingGenerator<S, E> other) {
        return this.compose(other, null);
    }

    public static <S, E> EmbeddingGenerator<S, E> compose(EmbeddingGenerator<S, E> a, EmbeddingGenerator<S, E> b, BinaryOperator<E> composer) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compose(b, composer);
    }

    public static <S, E> Optional<EmbeddingGenerator<S, E>> reduce(Stream<EmbeddingGenerator<S, E>> stream, BinaryOperator<E> composer) {
        return stream.reduce((a, b) -> EmbeddingGenerator.compose(a, b, composer));
    }

    public record Requirement(Class<?> sourceType, Class<?> embeddingType, Predicate<Class<? extends EmbeddingGenerator<?, ?>>> typePredicate, Predicate<EmbeddingGenerator<?, ?>> predicate) {
    }
}

