/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Collection;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.nasdanika.ai.Predictor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FittedPredictor<F, L, E>
extends Predictor<F, L> {
    public E getError();

    default public <G> FittedPredictor<G, L, E> adaptFeature(final Function<G, F> featureMapper) {
        return new FittedPredictor<G, L, E>(){

            @Override
            public L predict(G feature) {
                return FittedPredictor.this.predict(featureMapper.apply(feature));
            }

            @Override
            public Mono<L> predictAsync(G feature) {
                return FittedPredictor.this.predictAsync(featureMapper.apply(feature));
            }

            @Override
            public E getError() {
                return FittedPredictor.this.getError();
            }
        };
    }

    default public <G> FittedPredictor<G, L, E> adaptFeatureAsync(final Function<G, Mono<F>> featureMapper) {
        return new FittedPredictor<G, L, E>(){

            @Override
            public Mono<L> predictAsync(G feature) {
                return ((Mono)featureMapper.apply(feature)).flatMap(FittedPredictor.this::predictAsync);
            }

            @Override
            public E getError() {
                return FittedPredictor.this.getError();
            }
        };
    }

    default public <M> FittedPredictor<F, M, E> adaptLabel(final Function<L, M> labelMapper) {
        return new FittedPredictor<F, M, E>(){

            @Override
            public M predict(F feature) {
                return labelMapper.apply(FittedPredictor.this.predict(feature));
            }

            @Override
            public Mono<M> predictAsync(F feature) {
                return FittedPredictor.this.predictAsync(feature).map(labelMapper);
            }

            @Override
            public E getError() {
                return FittedPredictor.this.getError();
            }
        };
    }

    default public <M> FittedPredictor<F, M, E> adaptLabelAsync(final Function<L, Mono<M>> labelMapper) {
        return new FittedPredictor<F, M, E>(){

            @Override
            public Mono<M> predictAsync(F feature) {
                return FittedPredictor.this.predictAsync(feature).flatMap(labelMapper);
            }

            @Override
            public E getError() {
                return FittedPredictor.this.getError();
            }
        };
    }

    public static interface Fitter<F, L, E> {
        default public <S> FittedPredictor<F, L, E> fit(Collection<S> samples, Function<S, F> featureMapper, Function<S, L> labelMapper) {
            return (FittedPredictor)this.fitAsync(Flux.fromIterable(samples), s -> Mono.fromSupplier(() -> featureMapper.apply(s)), s -> Mono.fromSupplier(() -> labelMapper.apply(s))).block();
        }

        public <S> Mono<FittedPredictor<F, L, E>> fitAsync(Flux<S> var1, Function<S, Mono<F>> var2, Function<S, Mono<L>> var3);

        default public <G> Fitter<G, L, E> adaptFeature(final Function<G, F> featureMapper) {
            return new Fitter<G, L, E>(){

                @Override
                public <S> Mono<FittedPredictor<G, L, E>> fitAsync(Flux<S> samples, Function<S, Mono<G>> theFeatureMapper, Function<S, Mono<L>> labelMapper) {
                    Function<S, Mono> featureMapperChain = theFeatureMapper.andThen(m -> m.map(featureMapper));
                    Mono fResult = this.fitAsync(samples, featureMapperChain, labelMapper);
                    return fResult.map(fp -> fp.adaptFeature(featureMapper));
                }

                @Override
                public <S> FittedPredictor<G, L, E> fit(Collection<S> samples, Function<S, G> theFeatureMapper, Function<S, L> labelMapper) {
                    FittedPredictor predictor = this.fit(samples, theFeatureMapper.andThen(featureMapper), labelMapper);
                    return predictor.adaptFeature(featureMapper);
                }
            };
        }

        default public <G> Fitter<G, L, E> adaptFeatureAsync(final Function<G, Mono<F>> featureMapper) {
            return new Fitter<G, L, E>(){

                @Override
                public <S> Mono<FittedPredictor<G, L, E>> fitAsync(Flux<S> samples, Function<S, Mono<G>> theFeatureMapper, Function<S, Mono<L>> labelMapper) {
                    Function<S, Mono> featureMapperChain = theFeatureMapper.andThen(m -> m.flatMap(featureMapper));
                    Mono fResult = this.fitAsync(samples, featureMapperChain, labelMapper);
                    return fResult.map(fp -> fp.adaptFeatureAsync(featureMapper));
                }
            };
        }

        default public <M> Fitter<F, M, E> adaptLabel(final Function<M, L> fitMapper, final Function<L, M> predictMapper) {
            return new Fitter<F, M, E>(){

                @Override
                public <S> FittedPredictor<F, M, E> fit(Collection<S> samples, Function<S, F> featureMapper, Function<S, M> labelMapper) {
                    Function fitMapperChain = labelMapper.andThen(fitMapper);
                    FittedPredictor result = this.fit(samples, featureMapper, fitMapperChain);
                    return result.adaptLabel(predictMapper);
                }

                @Override
                public <S> Mono<FittedPredictor<F, M, E>> fitAsync(Flux<S> samples, Function<S, Mono<F>> featureMapper, Function<S, Mono<M>> labelMapper) {
                    Function<S, Mono> fitMapperChain = labelMapper.andThen(m -> m.map(fitMapper));
                    Mono result = this.fitAsync(samples, featureMapper, fitMapperChain);
                    return result.map(fp -> fp.adaptLabel(predictMapper));
                }
            };
        }

        default public <M> Fitter<F, M, E> adaptLabelAsync(final Function<M, Mono<L>> fitMapper, final Function<L, Mono<M>> predictMapper) {
            return new Fitter<F, M, E>(){

                @Override
                public <S> Mono<FittedPredictor<F, M, E>> fitAsync(Flux<S> samples, Function<S, Mono<F>> featureMapper, Function<S, Mono<M>> labelMapper) {
                    Function<S, Mono> fitMapperChain = labelMapper.andThen(m -> m.flatMap(fitMapper));
                    Mono result = this.fitAsync(samples, featureMapper, fitMapperChain);
                    return result.map(fp -> fp.adaptLabelAsync(predictMapper));
                }
            };
        }

        default public Fitter<F, L, E> compose(final Fitter<F, L, E> other, final BinaryOperator<L> add, final BinaryOperator<L> subtract, final ErrorComputer<F, L, E> errorComputer) {
            return new Fitter<F, L, E>(){

                @Override
                public <S> FittedPredictor<F, L, E> fit(final Collection<S> samples, final Function<S, F> featureMapper, final Function<S, L> labelMapper) {
                    final FittedPredictor thisPredictor = this.fit(samples, featureMapper, labelMapper);
                    final FittedPredictor otherPredictor = other.fit(samples, featureMapper, s -> {
                        Object label = labelMapper.apply(s);
                        Object prediction = thisPredictor.predict(featureMapper.apply(s));
                        return subtract.apply(label, prediction);
                    });
                    return new FittedPredictor<F, L, E>(){

                        @Override
                        public L predict(F feature) {
                            Object thisPrediction = thisPredictor.predict(feature);
                            Object otherPrediction = otherPredictor.predict(feature);
                            return add.apply(thisPrediction, otherPrediction);
                        }

                        @Override
                        public Mono<L> predictAsync(F input) {
                            Mono thisPrediction = thisPredictor.predictAsync(input);
                            Mono otherPrediction = otherPredictor.predictAsync(input);
                            return Mono.zip(thisPrediction, otherPrediction).map(tuple -> add.apply(tuple.getT1(), tuple.getT2()));
                        }

                        @Override
                        public E getError() {
                            return errorComputer == null ? null : (Object)errorComputer.computeError(this, samples, featureMapper, labelMapper);
                        }
                    };
                }

                @Override
                public <S> Mono<FittedPredictor<F, L, E>> fitAsync(Flux<S> samples, Function<S, Mono<F>> featureMapper, Function<S, Mono<L>> labelMapper) {
                    throw new UnsupportedOperationException("Implement me!");
                }
            };
        }
    }

    public static interface ErrorComputer<F, L, E> {
        public <S> E computeError(Predictor<F, L> var1, Collection<S> var2, Function<S, F> var3, Function<S, L> var4);
    }
}

