/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.List;
import org.nasdanika.ai.VectorSimilarityComputer;
import reactor.core.publisher.Mono;

public interface FloatVectorSimilarityComputer
extends VectorSimilarityComputer<Float, Float> {
    public static final FloatVectorSimilarityComputer COSINE_SIMILARITY_COMPUTER = new FloatVectorSimilarityComputer(){

        @Override
        public Mono<Float> computeAsync(List<Float> a, List<Float> b) {
            float dot = 0.0f;
            float nru = 0.0f;
            float nrv = 0.0f;
            for (int i = 0; i < a.size(); ++i) {
                dot += a.get(i).floatValue() * b.get(i).floatValue();
                nru += a.get(i).floatValue() * a.get(i).floatValue();
                nrv += b.get(i).floatValue() * b.get(i).floatValue();
            }
            return Mono.just((Object)Float.valueOf(dot / (float)(Math.sqrt(nru) * Math.sqrt(nrv))));
        }
    };
}

