/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.nasdanika.ai.EmbeddingGenerator;
import reactor.core.publisher.Mono;

public interface ImageEmbeddingGenerator<E>
extends EmbeddingGenerator<BufferedImage, E> {
    default public EmbeddingGenerator<InputStream, E> asInputStreamEmbeddingGenerator() {
        Function<InputStream, Mono> mapper = in -> {
            try {
                return Mono.just((Object)ImageIO.read(in));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from input stream: " + String.valueOf(e), e);
            }
        };
        return this.adapt(mapper);
    }

    default public EmbeddingGenerator<URL, E> asUrlEmbeddingGenerator() {
        Function<URL, Mono> mapper = url -> {
            try {
                return Mono.just((Object)ImageIO.read(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from '" + String.valueOf(url) + "': " + String.valueOf(e), e);
            }
        };
        return this.adapt(mapper);
    }

    default public EmbeddingGenerator<File, E> asFileEmbeddingGenerator() {
        Function<File, Mono> mapper = file -> {
            try {
                return Mono.just((Object)ImageIO.read(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from '" + file.getAbsolutePath() + "': " + String.valueOf(e), e);
            }
        };
        return this.adapt(mapper);
    }
}

