/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Map;
import java.util.function.Function;
import org.nasdanika.ai.CachingEmbeddingGenerator;
import org.nasdanika.ai.EmbeddingGenerator;

public abstract class MapCachingEmbeddingGenerator<S, E, K>
extends CachingEmbeddingGenerator<S, E, K> {
    protected Map<K, E> cache;

    @Override
    protected abstract K computeKey(S var1);

    protected MapCachingEmbeddingGenerator(EmbeddingGenerator<S, E> target, Map<K, E> cache) {
        super(target);
        this.cache = cache;
    }

    public static <S, E, K> MapCachingEmbeddingGenerator<S, E, K> create(EmbeddingGenerator<S, E> target, Map<K, E> cache, final Function<S, K> keyComputer) {
        return new MapCachingEmbeddingGenerator<S, E, K>(target, cache){

            @Override
            protected K computeKey(S source) {
                return keyComputer.apply(source);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected E get(K key) {
        Map<K, E> map = this.cache;
        synchronized (map) {
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void put(K key, E value) {
        Map<K, E> map = this.cache;
        synchronized (map) {
            this.cache.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E generate(S input) {
        Map<K, E> map = this.cache;
        synchronized (map) {
            return (E)this.cache.computeIfAbsent(this.computeKey(input), d -> this.target.generate(input));
        }
    }
}

