/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Predictor<F, L> {
    default public L predict(F feature) {
        return (L)this.predictAsync(feature).block();
    }

    public Mono<L> predictAsync(F var1);

    default public List<Sample<F, L>> predict(Collection<F> input) {
        return (List)this.predictAsync(Flux.fromIterable(input)).block();
    }

    default public Mono<List<Sample<F, L>>> predictAsync(Flux<F> input) {
        return input.flatMap(ie -> {
            Mono<L> embMono = this.predictAsync(ie);
            return embMono.map(emb -> new Sample<Object, Object>(ie, emb));
        }).collectList();
    }

    default public <G> Predictor<G, L> adaptFeature(final Function<G, F> featureMapper) {
        return new Predictor<G, L>(){

            @Override
            public L predict(G feature) {
                return Predictor.this.predict(featureMapper.apply(feature));
            }

            @Override
            public Mono<L> predictAsync(G feature) {
                return Predictor.this.predictAsync(featureMapper.apply(feature));
            }
        };
    }

    default public <G> Predictor<G, L> adaptFeatureAsync(final Function<G, Mono<F>> featureMapper) {
        return new Predictor<G, L>(){

            @Override
            public Mono<L> predictAsync(G feature) {
                return ((Mono)featureMapper.apply(feature)).flatMap(Predictor.this::predictAsync);
            }
        };
    }

    default public <M> Predictor<F, M> adaptLabel(final Function<L, M> labelMapper) {
        return new Predictor<F, M>(){

            @Override
            public M predict(F feature) {
                return labelMapper.apply(Predictor.this.predict(feature));
            }

            @Override
            public Mono<M> predictAsync(F feature) {
                return Predictor.this.predictAsync(feature).map(labelMapper);
            }
        };
    }

    default public <M> Predictor<F, M> adaptLabelAsync(final Function<L, Mono<M>> labelMapper) {
        return new Predictor<F, M>(){

            @Override
            public Mono<M> predictAsync(F feature) {
                return Predictor.this.predictAsync(feature).flatMap(labelMapper);
            }
        };
    }

    public record Sample<F, L>(F feature, L label) {
    }
}

