/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.function.Function;
import reactor.core.publisher.Mono;

public interface SimilarityComputer<T, S> {
    default public S compute(T a, T b) {
        return (S)this.computeAsync(a, b).block();
    }

    public Mono<S> computeAsync(T var1, T var2);

    default public Mono<S> computeAsync(Mono<T> a, Mono<T> b) {
        return Mono.zip(a, b).flatMap(t -> this.computeAsync(t.getT1(), t.getT2()));
    }

    default public <V> SimilarityComputer<V, S> adapt(final Function<V, Mono<T>> mapper) {
        return new SimilarityComputer<V, S>(){

            @Override
            public Mono<S> computeAsync(V a, V b) {
                Mono ma = (Mono)mapper.apply(a);
                Mono mb = (Mono)mapper.apply(b);
                return SimilarityComputer.this.computeAsync(ma, mb);
            }

            @Override
            public Mono<S> computeAsync(Mono<V> a, Mono<V> b) {
                Mono ma = a.flatMap(mapper);
                Mono mb = b.flatMap(mapper);
                return SimilarityComputer.this.computeAsync(ma, mb);
            }
        };
    }
}

