/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.Arrays;
import java.util.List;
import org.nasdanika.ai.Model;

public interface Chat
extends Model {
    public List<ResponseMessage> chat(List<Message> var1);

    default public List<ResponseMessage> chat(Message ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    public int getMaxOutputTokens();

    public static enum Role {
        system,
        assistant,
        user,
        function,
        tool,
        developer;


        public Message createMessage(String content) {
            return Message.create(this.name(), content);
        }
    }

    public static interface ResponseMessage
    extends Message {
        public String getRefusal();

        public String getFinishReason();
    }

    public static interface Message {
        public String getRole();

        public String getContent();

        public static Message create(final String role, final String content) {
            return new Message(){

                @Override
                public String getRole() {
                    return role;
                }

                @Override
                public String getContent() {
                    return content;
                }
            };
        }
    }
}

