/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.nasdanika.ai.SimilarityComputer;
import reactor.core.publisher.Mono;

public interface BufferedImageSimilarityComputer<S>
extends SimilarityComputer<BufferedImage, S> {
    default public SimilarityComputer<InputStream, S> asInputStreamSimilarityComputer() {
        Function<InputStream, Mono> mapper = in -> {
            try {
                return Mono.just((Object)ImageIO.read(in));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from input stream: " + e, e);
            }
        };
        return this.adapt(mapper);
    }

    default public SimilarityComputer<URL, S> asUrlSimilarityComputer() {
        Function<URL, Mono> mapper = url -> {
            try {
                return Mono.just((Object)ImageIO.read(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from '" + url + "': " + e, e);
            }
        };
        return this.adapt(mapper);
    }

    default public SimilarityComputer<File, S> asFileSimilarityComputer() {
        Function<File, Mono> mapper = file -> {
            try {
                return Mono.just((Object)ImageIO.read(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from '" + file.getAbsolutePath() + "': " + e, e);
            }
        };
        return this.adapt(mapper);
    }
}

