/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.nasdanika.ai.ImageEmbeddingGenerator;
import org.nasdanika.ai.MapCachingEmbeddingGenerator;

public class CachingImageEmbeddingGenerator<E>
extends MapCachingEmbeddingGenerator<BufferedImage, E, String>
implements ImageEmbeddingGenerator<E> {
    private String algorithm;

    public CachingImageEmbeddingGenerator(ImageEmbeddingGenerator<E> target, Map<String, E> cache, String algorithm) {
        super(target, cache);
        this.algorithm = algorithm;
    }

    public CachingImageEmbeddingGenerator(ImageEmbeddingGenerator<E> target, Map<String, E> cache) {
        this(target, cache, "SHA-512");
    }

    @Override
    protected String computeKey(BufferedImage input) {
        try {
            ByteArrayOutputStream baos;
            try (ByteArrayOutputStream byteArrayOutputStream = baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)input, "png", baos);
            }
            byte[] imageBytes = baos.toByteArray();
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            byte[] dBytes = digest.digest(imageBytes);
            StringBuilder sb = new StringBuilder();
            for (byte b : dBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Error computing image digest: " + e, e);
        }
    }
}

