/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.nasdanika.ai.MapCachingEmbeddingGenerator;
import org.nasdanika.ai.TextEmbeddingGenerator;

public class CachingTextEmbeddingGenerator<E>
extends MapCachingEmbeddingGenerator<String, E, String>
implements TextEmbeddingGenerator<E> {
    private String algorithm;

    public CachingTextEmbeddingGenerator(TextEmbeddingGenerator<E> target, Map<String, E> cache, String algorithm) {
        super(target, cache);
        this.algorithm = algorithm;
    }

    public CachingTextEmbeddingGenerator(TextEmbeddingGenerator<E> target, Map<String, E> cache) {
        this(target, cache, "SHA-512");
    }

    @Override
    protected String computeKey(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this.algorithm);
            byte[] dBytes = digest.digest(input.getBytes(this.getCharset()));
            StringBuilder sb = new StringBuilder();
            for (byte b : dBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Error computing text digest: " + e, e);
        }
    }

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }
}

