/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.nasdanika.ai.Model;
import reactor.core.publisher.Mono;

public interface Chat
extends Model {
    public Mono<List<ResponseMessage>> chatAsync(List<Message> var1);

    default public Mono<List<ResponseMessage>> chatAsync(Message ... messages) {
        return this.chatAsync(Arrays.asList(messages));
    }

    default public List<ResponseMessage> chat(List<Message> messages) {
        return (List)this.chatAsync(messages).block();
    }

    default public List<ResponseMessage> chat(Message ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    public int getMaxOutputTokens();

    public static enum Role {
        system,
        assistant,
        user,
        function,
        tool,
        developer;


        public Message createMessage(String content) {
            return Message.create(this.name(), content);
        }
    }

    public static interface ResponseMessage
    extends Message {
        public String getRefusal();

        public String getFinishReason();

        @Override
        default public Message addImage(String dataUrl) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public List<String> getImages() {
            return Collections.emptyList();
        }
    }

    public static interface Message {
        public String getRole();

        public String getContent();

        public List<String> getImages();

        public Message addImage(String var1);

        default public Message addImage(File file) {
            try {
                return this.addImage(ImageIO.read(file));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from file '" + file.getAbsolutePath() + "': " + e, e);
            }
        }

        default public Message addImage(InputStream inputStream) {
            try {
                return this.addImage(ImageIO.read(inputStream));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from input stream: " + e, e);
            }
        }

        default public Message addImage(URL url) {
            try {
                return this.addImage(ImageIO.read(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read image from URL '" + url + "': " + e, e);
            }
        }

        default public Message addImage(BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                try (ByteArrayOutputStream byteArrayOutputStream = baos;){
                    ImageIO.write((RenderedImage)image, "PNG", baos);
                }
                String base64Image = Base64.getEncoder().encodeToString(baos.toByteArray());
                return this.addImage("data:image/png;base64," + base64Image);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot write image: " + e, e);
            }
        }

        public static Message create(final String role, final String content) {
            return new Message(){
                private List<String> images = new ArrayList<String>();

                @Override
                public String getRole() {
                    return role;
                }

                @Override
                public String getContent() {
                    return content;
                }

                @Override
                public List<String> getImages() {
                    return Collections.unmodifiableList(this.images);
                }

                @Override
                public Message addImage(String dataUrl) {
                    this.images.add(dataUrl);
                    return this;
                }
            };
        }
    }

    public record Requirement(String provider, String model, String version) {
    }
}

