/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.awt.image.BufferedImage;
import java.util.List;
import org.nasdanika.ai.Chat;
import org.nasdanika.ai.ImageNarrator;
import reactor.core.publisher.Mono;

public class ChatImageNarrator
implements ImageNarrator {
    private Chat chat;
    private String prompt;

    public ChatImageNarrator(Chat chat, String prompt) {
        this.chat = chat;
        this.prompt = prompt;
    }

    public ChatImageNarrator(Chat chat) {
        this(chat, "Describe this image");
    }

    @Override
    public Mono<String> generateAsync(BufferedImage input) {
        Mono<List<Chat.ResponseMessage>> responses = this.chat.chatAsync(Chat.Role.user.createMessage(this.prompt).addImage(input));
        return responses.map(responseMessages -> {
            StringBuilder resultBuilder = new StringBuilder();
            for (Chat.ResponseMessage responseMessage : responseMessages) {
                if (resultBuilder.length() > 0) {
                    resultBuilder.append(System.lineSeparator());
                }
                resultBuilder.append(responseMessage.getContent());
            }
            return resultBuilder.toString();
        });
    }

    @Override
    public String generate(BufferedImage input) {
        List<Chat.ResponseMessage> responses = this.chat.chat(Chat.Role.user.createMessage(this.prompt).addImage(input));
        StringBuilder resultBuilder = new StringBuilder();
        for (Chat.ResponseMessage response : responses) {
            if (resultBuilder.length() > 0) {
                resultBuilder.append(System.lineSeparator());
            }
            resultBuilder.append(response.getContent());
        }
        return resultBuilder.toString();
    }
}

