/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nasdanika.ai.SimilarityComputer;
import reactor.core.publisher.Mono;

public class CompositeFloatSimilarityComputer<T>
implements SimilarityComputer<T, Float> {
    protected Collection<Map.Entry<SimilarityComputer<? super T, Float>, Float>> computers = Collections.synchronizedCollection(new ArrayList());
    protected float totalWeight;

    public synchronized CompositeFloatSimilarityComputer<T> addComputer(SimilarityComputer<? super T, Float> computer, float weight) {
        if (weight != 0.0f) {
            this.computers.add(Map.entry(computer, Float.valueOf(weight)));
            this.totalWeight += weight;
        }
        return this;
    }

    @Override
    public Mono<Float> computeAsync(T a, T b) {
        if (this.computers.isEmpty() || this.totalWeight == 0.0f) {
            return Mono.just((Object)Float.valueOf(0.0f));
        }
        List<Mono> results = this.computers.stream().map(e -> ((SimilarityComputer)e.getKey()).computeAsync(a, b).map(r -> Float.valueOf(r.floatValue() * ((Float)e.getValue()).floatValue()))).toList();
        return Mono.zip(results, ra -> {
            float total = 0.0f;
            for (int i = 0; i < ((Object[])ra).length; ++i) {
                total += ((Float)ra[i]).floatValue();
            }
            return Float.valueOf(total / this.totalWeight);
        });
    }
}

