/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

public interface EmbeddingGenerator<S, E> {
    default public E generate(S input) {
        return (E)this.generateAsync(input).block();
    }

    public Mono<E> generateAsync(S var1);

    default public Map<S, E> generate(List<S> input) {
        return (Map)this.generateAsync(input).block();
    }

    default public Mono<Map<S, E>> generateAsync(List<S> input) {
        List<Mono> monos = input.stream().map(ie -> {
            Mono<E> embMono = this.generateAsync(ie);
            return embMono.map(emb -> Map.entry(ie, emb));
        }).toList();
        return Mono.zip(monos, this::combine);
    }

    private Map<S, E> combine(Object[] elements) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Object el : elements) {
            Map.Entry e = (Map.Entry)el;
            ret.put(e.getKey(), e.getValue());
        }
        return ret;
    }

    default public <F> EmbeddingGenerator<S, F> then(final EmbeddingGenerator<E, F> next) {
        return new EmbeddingGenerator<S, F>(){

            @Override
            public Mono<F> generateAsync(S source) {
                return EmbeddingGenerator.this.generateAsync(source).flatMap(next::generateAsync);
            }
        };
    }

    default public <V> EmbeddingGenerator<V, E> adapt(final Function<V, Mono<S>> mapper) {
        return new EmbeddingGenerator<V, E>(){

            @Override
            public Mono<E> generateAsync(V source) {
                return ((Mono)mapper.apply(source)).flatMap(EmbeddingGenerator.this::generateAsync);
            }
        };
    }

    public record Requirement(Class<?> sourceType, Class<?> embeddingType, Predicate<Class<? extends EmbeddingGenerator<?, ?>>> typePredicate, Predicate<EmbeddingGenerator<?, ?>> predicate) {
    }
}

