/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nasdanika.ai.TextFloatVectorEmbeddingModel;
import reactor.core.publisher.Mono;

public abstract class TextFloatVectorChunkingEmbeddingModel<T>
implements TextFloatVectorEmbeddingModel {
    private TextFloatVectorEmbeddingModel target;
    private int chunkSize;
    private int overlap;

    protected TextFloatVectorChunkingEmbeddingModel(TextFloatVectorEmbeddingModel target, int chunkSize, int overlap) {
        this.target = target;
        this.chunkSize = chunkSize > 0 ? chunkSize : target.getMaxInputTokens();
        this.overlap = overlap;
    }

    @Override
    public String getProvider() {
        return this.target.getProvider();
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    public String getVersion() {
        return this.target.getVersion();
    }

    @Override
    public int getMaxInputTokens() {
        return -1;
    }

    @Override
    public boolean isTooLong(String input) {
        return false;
    }

    @Override
    public int getDimensions() {
        return this.target.getDimensions();
    }

    public List<String> chunk(String input) {
        ArrayList<String> result = new ArrayList<String>();
        T tokens = this.encode(input);
        int l = this.size(tokens);
        for (int i = 0; i < l; i += this.chunkSize) {
            if (i > this.overlap) {
                i -= this.overlap;
            }
            T slice = this.slice(tokens, i, this.chunkSize);
            result.add(this.decode(slice));
        }
        return result;
    }

    @Override
    public Mono<List<List<Float>>> generateAsync(String input) {
        List<String> chunks = this.chunk(input);
        return this.target.generateAsync(chunks).map(chunkMap -> {
            ArrayList result = new ArrayList();
            for (String chunk : chunks) {
                result.addAll((Collection)chunkMap.get(chunk));
            }
            return result;
        });
    }

    @Override
    public List<List<Float>> generate(String input) {
        ArrayList<List<Float>> result = new ArrayList<List<Float>>();
        for (String chunk : this.chunk(input)) {
            result.addAll((Collection)this.target.generate(chunk));
        }
        return result;
    }

    protected abstract T encode(String var1);

    protected abstract String decode(T var1);

    protected abstract int size(T var1);

    protected abstract T slice(T var1, int var2, int var3);
}

