/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.drawio;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.nasdanika.ai.ImageMetadataNarrator;
import org.nasdanika.ai.Narrator;
import org.nasdanika.drawio.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import reactor.core.publisher.Mono;

public abstract class DocumentImageMetadataNarrator<S>
extends ImageMetadataNarrator<S> {
    private static Logger LOGGER = LoggerFactory.getLogger(DocumentImageMetadataNarrator.class);
    protected Narrator<Document> documentNarrator;

    protected DocumentImageMetadataNarrator(Narrator<Document> documentNarrator) {
        this.documentNarrator = documentNarrator;
    }

    public Mono<String> generateAsync(S input) {
        return this.narrateMetadataAsync(this.getImageMetadata(input));
    }

    public String generate(S input) {
        return this.narrateMetadata(this.getImageMetadata(input));
    }

    protected abstract ImageMetadata getImageMetadata(S var1);

    protected String narrateMetadata(ImageMetadata metadata) {
        List items;
        if (metadata != null && (items = metadata.getItems()) != null) {
            for (ImageMetadata.ImageMetadataItem item : items) {
                GenericImageMetadata.GenericImageMetadataItem gItem;
                if (!(item instanceof GenericImageMetadata.GenericImageMetadataItem) || !"mxfile".equals((gItem = (GenericImageMetadata.GenericImageMetadataItem)item).getKeyword())) continue;
                try {
                    Document document = Document.load((String)gItem.getText(), null);
                    return (String)this.documentNarrator.generate((Object)document);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LOGGER.error("Could not narrate document from metadata: " + String.valueOf(e), (Throwable)e);
                }
            }
        }
        return super.narrateMetadata(metadata);
    }

    protected Mono<String> narrateMetadataAsync(ImageMetadata metadata) {
        return Mono.just((Object)this.narrateMetadata(metadata));
    }
}

