/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.drawio;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.eclipse.emf.common.util.URI;
import org.nasdanika.ai.Narrator;
import org.nasdanika.ai.drawio.DocumentImageMetadataNarrator;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.drawio.Document;

public class UriDocumentImageMetadataNarrator
extends DocumentImageMetadataNarrator<URI> {
    public UriDocumentImageMetadataNarrator(Narrator<Document> documentNarrator) {
        super(documentNarrator);
    }

    @Override
    protected ImageMetadata getImageMetadata(URI source) {
        try {
            String uriStr = source.toString();
            if (uriStr.startsWith("data:")) {
                int commaIndex = uriStr.indexOf(44);
                String metadata = uriStr.substring(5, commaIndex);
                String dataPart = uriStr.substring(commaIndex + 1);
                byte[] bytes = metadata.contains(";base64") ? Base64.getDecoder().decode(dataPart) : URLDecoder.decode(dataPart, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
                return Imaging.getMetadata((byte[])bytes);
            }
            return Imaging.getMetadata((InputStream)new URL(uriStr).openStream(), (String)source.lastSegment());
        }
        catch (IOException e) {
            throw new NasdanikaException((Throwable)e);
        }
    }
}

