/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp.sse;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.opentelemetry.api.OpenTelemetry;
import org.nasdanika.ai.mcp.McpAsyncServerProvider;
import org.nasdanika.ai.mcp.sse.HttpServerRoutesTransportProvider;
import org.nasdanika.ai.mcp.sse.ModuleVersionProvider;
import org.nasdanika.cli.ParentCommands;
import org.nasdanika.common.Description;
import org.nasdanika.http.AbstractHttpServerCommand;
import picocli.CommandLine;
import reactor.netty.http.server.HttpServerRoutes;

@CommandLine.Command(description={"MCP SSE Transport"}, versionProvider=ModuleVersionProvider.class, mixinStandardHelpOptions=true, name="sse")
@ParentCommands(value={McpAsyncServerProvider.class})
@Description(icon="https://docs.nasdanika.org/images/http.svg")
public class SseTransportCommand
extends AbstractHttpServerCommand {
    private OpenTelemetry openTelemetry;
    @CommandLine.ParentCommand
    private McpAsyncServerProvider asyncServerProvider;
    @CommandLine.Option(names={"--base-path"}, defaultValue="")
    private String basePath = "";
    @CommandLine.Option(names={"--resolve-remote-host-name"}, negatable=true, defaultValue="true")
    private boolean resolveRemoteHostName;
    @CommandLine.Option(names={"--message-endpoint"}, description={"Defaults to ${DEFAULT-VALUE}"}, defaultValue="/sse")
    private String messageEndpoint;
    @CommandLine.Option(names={"--sse-endpoint"}, description={"Defaults to ${DEFAULT-VALUE}"}, defaultValue="/sse")
    private String sseEndpoint;

    public SseTransportCommand(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    protected String getInstrumentationScopeName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void buildRoutes(HttpServerRoutes routes) {
        HttpServerRoutesTransportProvider transportProvider = HttpServerRoutesTransportProvider.builder().propagator(this.openTelemetry.getPropagators().getTextMapPropagator()).tracer(this.openTelemetry.getTracer(this.getInstrumentationScopeName())).basePath(this.basePath).resolveRemoteHostName(this.resolveRemoteHostName).sseEndpoint(this.sseEndpoint).messageEndpoint(this.messageEndpoint).objectMapper(new ObjectMapper()).build(routes);
        this.asyncServerProvider.createServer((McpServerTransportProvider)transportProvider);
    }

    public Integer call() throws Exception {
        this.startServer(this::buildRoutes);
        return 0;
    }
}

