/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.nasdanika.ai.mcp.McpAsyncServerProvider;
import org.nasdanika.ai.mcp.McpTelemetryFilter;
import org.nasdanika.capability.CapabilityLoader;
import org.nasdanika.cli.CommandGroup;
import reactor.core.publisher.Mono;

public class McpServerCommandBase
extends CommandGroup
implements McpAsyncServerProvider {
    private OpenTelemetry openTelemetry;

    public McpServerCommandBase(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public McpServerCommandBase(CapabilityLoader capabilityLoader, OpenTelemetry openTelemetry) {
        super(capabilityLoader);
        this.openTelemetry = openTelemetry;
    }

    public Collection<McpServerFeatures.AsyncResourceSpecification> getResourceSpecifications() {
        return Collections.emptyList();
    }

    public Collection<McpServerFeatures.AsyncToolSpecification> getToolSpecifications() {
        return Collections.emptyList();
    }

    public Collection<McpServerFeatures.AsyncPromptSpecification> getPromptSpecifications() {
        return Collections.emptyList();
    }

    protected boolean isLogging() {
        return true;
    }

    protected void measureDuration(String name, long duration) {
    }

    @Override
    public McpAsyncServer createServer(McpServerTransportProvider transportProvider) {
        Collection<McpServerFeatures.AsyncPromptSpecification> promptSpecifications;
        Collection<McpServerFeatures.AsyncToolSpecification> toolSpecifications;
        McpSchema.ServerCapabilities.Builder capabilitiesBuilder = McpSchema.ServerCapabilities.builder();
        Collection<McpServerFeatures.AsyncResourceSpecification> resourceSpecifications = this.getResourceSpecifications();
        if (!resourceSpecifications.isEmpty()) {
            capabilitiesBuilder.resources(Boolean.valueOf(true), Boolean.valueOf(true));
        }
        if (!(toolSpecifications = this.getToolSpecifications()).isEmpty()) {
            capabilitiesBuilder.tools(Boolean.valueOf(true));
        }
        if (!(promptSpecifications = this.getPromptSpecifications()).isEmpty()) {
            capabilitiesBuilder.prompts(Boolean.valueOf(true));
        }
        if (this.isLogging()) {
            capabilitiesBuilder.logging();
        }
        McpAsyncServer asyncServer = McpServer.async((McpServerTransportProvider)transportProvider).serverInfo(this.getName(), this.getVersion()).capabilities(capabilitiesBuilder.build()).build();
        Tracer tracer = this.openTelemetry.getTracer(this.getInstrumentationScopeName());
        McpTelemetryFilter mcpTelemetryFilter = new McpTelemetryFilter(tracer, this::measureDuration);
        ArrayList<Mono> registrations = new ArrayList<Mono>();
        for (McpServerFeatures.AsyncResourceSpecification rSpec : resourceSpecifications) {
            registrations.add(asyncServer.addResource(mcpTelemetryFilter.filter(rSpec)));
        }
        for (McpServerFeatures.AsyncToolSpecification tSpec : toolSpecifications) {
            registrations.add(asyncServer.addTool(mcpTelemetryFilter.filter(tSpec)));
        }
        for (McpServerFeatures.AsyncPromptSpecification pSpec : promptSpecifications) {
            registrations.add(asyncServer.addPrompt(mcpTelemetryFilter.filter(pSpec)));
        }
        return (McpAsyncServer)Mono.zip(registrations, ra -> asyncServer).block();
    }

    protected String getInstrumentationScopeName() {
        return this.getClass().getName();
    }

    protected String getName() {
        return this.spec.name();
    }

    protected String getVersion() {
        CharSequence[] version = this.spec.version();
        if (version == null) {
            return "(unknown)";
        }
        if (version.length == 1) {
            return version[0];
        }
        return String.join((CharSequence)" ", version);
    }
}

