/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.opentelemetry.api.OpenTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.nasdanika.ai.mcp.McpServerCommand;
import org.nasdanika.capability.CapabilityFactory;
import org.nasdanika.capability.CapabilityProvider;
import org.nasdanika.capability.ServiceCapabilityFactory;
import org.nasdanika.cli.SubCommandCapabilityFactory;
import org.nasdanika.common.ProgressMonitor;
import picocli.CommandLine;

public class McpServerCommandFactory
extends SubCommandCapabilityFactory<McpServerCommand> {
    protected Class<McpServerCommand> getCommandType() {
        return McpServerCommand.class;
    }

    protected CompletionStage<McpServerCommand> doCreateCommand(List<CommandLine> parentPath, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement openTelemetryRequirement = ServiceCapabilityFactory.createRequirement(OpenTelemetry.class);
        CompletionStage openTelemetryCS = loader.loadOne((Object)openTelemetryRequirement, progressMonitor);
        return openTelemetryCS.thenApply(ServerConfig::new).thenCompose(config -> this.syncPromptSpecifications((ServerConfig)config, loader, progressMonitor)).thenCompose(config -> this.asyncPromptSpecifications((ServerConfig)config, loader, progressMonitor)).thenCompose(config -> this.syncResourceSpecifications((ServerConfig)config, loader, progressMonitor)).thenCompose(config -> this.asyncResourceSpecifications((ServerConfig)config, loader, progressMonitor)).thenCompose(config -> this.syncToolSpecifications((ServerConfig)config, loader, progressMonitor)).thenCompose(config -> this.asyncToolSpecifications((ServerConfig)config, loader, progressMonitor)).thenApply(this::createCommand);
    }

    protected CompletionStage<ServerConfig> syncPromptSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.SyncPromptSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.syncPromptSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    protected CompletionStage<ServerConfig> asyncPromptSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.AsyncPromptSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.asyncPromptSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    protected CompletionStage<ServerConfig> syncResourceSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.SyncResourceSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.syncResourceSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    protected CompletionStage<ServerConfig> asyncResourceSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.AsyncResourceSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.asyncResourceSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    protected CompletionStage<ServerConfig> syncToolSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.SyncToolSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.syncToolSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    protected CompletionStage<ServerConfig> asyncToolSpecifications(ServerConfig config, CapabilityFactory.Loader loader, ProgressMonitor progressMonitor) {
        ServiceCapabilityFactory.Requirement requirement = ServiceCapabilityFactory.createRequirement(McpServerFeatures.AsyncToolSpecification.class);
        CompletionStage cs = loader.load((Object)requirement, progressMonitor);
        return cs.thenApply(capabilityProviders -> {
            for (CapabilityProvider capabilityProvider : capabilityProviders) {
                config.asyncToolSpecifications().addAll((Collection)capabilityProvider.getPublisher().collect(Collectors.toList()).block());
            }
            return config;
        });
    }

    private McpServerCommand createCommand(ServerConfig config) {
        McpServerCommand server = new McpServerCommand(config.openTelemetry(), config.syncPromptSpecifications(), config.asyncPromptSpecifications(), config.syncResourceSpecifications(), config.asyncResourceSpecifications(), config.syncToolSpecifications(), config.asyncToolSpecifications());
        return server.isEmpty() ? null : server;
    }

    private record ServerConfig(OpenTelemetry openTelemetry, Collection<McpServerFeatures.SyncPromptSpecification> syncPromptSpecifications, Collection<McpServerFeatures.AsyncPromptSpecification> asyncPromptSpecifications, Collection<McpServerFeatures.SyncResourceSpecification> syncResourceSpecifications, Collection<McpServerFeatures.AsyncResourceSpecification> asyncResourceSpecifications, Collection<McpServerFeatures.SyncToolSpecification> syncToolSpecifications, Collection<McpServerFeatures.AsyncToolSpecification> asyncToolSpecifications) {
        public ServerConfig(OpenTelemetry openTelemetry) {
            this(openTelemetry, Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()));
        }
    }
}

