/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import io.opentelemetry.api.OpenTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import org.nasdanika.ai.mcp.McpServerCommandBase;
import org.nasdanika.ai.mcp.ModuleVersionProvider;
import org.nasdanika.cli.ParentCommands;
import org.nasdanika.cli.RootCommand;
import org.nasdanika.common.Description;
import picocli.CommandLine;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@CommandLine.Command(description={"MCP server"}, versionProvider=ModuleVersionProvider.class, mixinStandardHelpOptions=true, name="mcp-server")
@ParentCommands(value={RootCommand.class})
@Description(icon="https://docs.nasdanika.org/images/mcp.png")
public class McpServerCommand
extends McpServerCommandBase {
    private Collection<McpServerFeatures.AsyncResourceSpecification> resourceSpecifications = new ArrayList<McpServerFeatures.AsyncResourceSpecification>();
    private Collection<McpServerFeatures.AsyncToolSpecification> toolSpecifications = new ArrayList<McpServerFeatures.AsyncToolSpecification>();
    private Collection<McpServerFeatures.AsyncPromptSpecification> promptSpecifications = new ArrayList<McpServerFeatures.AsyncPromptSpecification>();

    public McpServerCommand(OpenTelemetry openTelemetry, Collection<McpServerFeatures.SyncPromptSpecification> syncPromptSpecifications, Collection<McpServerFeatures.AsyncPromptSpecification> asyncPromptSpecifications, Collection<McpServerFeatures.SyncResourceSpecification> syncResourceSpecifications, Collection<McpServerFeatures.AsyncResourceSpecification> asyncResourceSpecifications, Collection<McpServerFeatures.SyncToolSpecification> syncToolSpecifications, Collection<McpServerFeatures.AsyncToolSpecification> asyncToolSpecifications) {
        super(openTelemetry);
        if (syncPromptSpecifications != null) {
            for (McpServerFeatures.SyncPromptSpecification syncPromptSpecification : syncPromptSpecifications) {
                this.promptSpecifications.add(new McpServerFeatures.AsyncPromptSpecification(syncPromptSpecification.prompt(), (exchange, req) -> Mono.fromCallable(() -> (McpSchema.GetPromptResult)syncPromptSpecification.promptHandler().apply(new McpSyncServerExchange(exchange), req)).subscribeOn(Schedulers.boundedElastic())));
            }
        }
        if (asyncPromptSpecifications != null) {
            this.promptSpecifications.addAll(asyncPromptSpecifications);
        }
        if (syncResourceSpecifications != null) {
            for (McpServerFeatures.SyncResourceSpecification syncResourceSpecification : syncResourceSpecifications) {
                this.resourceSpecifications.add(new McpServerFeatures.AsyncResourceSpecification(syncResourceSpecification.resource(), (exchange, req) -> Mono.fromCallable(() -> (McpSchema.ReadResourceResult)syncResourceSpecification.readHandler().apply(new McpSyncServerExchange(exchange), req)).subscribeOn(Schedulers.boundedElastic())));
            }
        }
        if (asyncResourceSpecifications != null) {
            this.resourceSpecifications.addAll(asyncResourceSpecifications);
        }
        if (syncToolSpecifications != null) {
            for (McpServerFeatures.SyncToolSpecification syncToolSpecification : syncToolSpecifications) {
                this.toolSpecifications.add(new McpServerFeatures.AsyncToolSpecification(syncToolSpecification.tool(), (exchange, req) -> Mono.fromCallable(() -> (McpSchema.CallToolResult)syncToolSpecification.call().apply(new McpSyncServerExchange(exchange), req)).subscribeOn(Schedulers.boundedElastic())));
            }
        }
        if (asyncToolSpecifications != null) {
            this.toolSpecifications.addAll(asyncToolSpecifications);
        }
    }

    public boolean isEmpty() {
        return this.resourceSpecifications.isEmpty() && this.toolSpecifications.isEmpty() && this.promptSpecifications.isEmpty();
    }

    @Override
    public Collection<McpServerFeatures.AsyncResourceSpecification> getResourceSpecifications() {
        return this.resourceSpecifications;
    }

    @Override
    public Collection<McpServerFeatures.AsyncToolSpecification> getToolSpecifications() {
        return this.toolSpecifications;
    }

    @Override
    public Collection<McpServerFeatures.AsyncPromptSpecification> getPromptSpecifications() {
        return this.promptSpecifications;
    }
}

