/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.Map;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class McpTelemetryFilter {
    protected Tracer tracer;
    protected BiConsumer<String, Long> durationConsumer;

    public McpTelemetryFilter(Tracer tracer, BiConsumer<String, Long> durationConsumer) {
        this.tracer = tracer;
        this.durationConsumer = durationConsumer;
    }

    public McpServerFeatures.SyncToolSpecification filter(McpServerFeatures.SyncToolSpecification syncToolSpecification) {
        return new McpServerFeatures.SyncToolSpecification(syncToolSpecification.tool(), (exchange, request) -> {
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Sync tool " + syncToolSpecification.tool().name()).setAttribute("description", syncToolSpecification.tool().description()).startSpan();
            for (Map.Entry re : request.entrySet()) {
                span.setAttribute("request." + (String)re.getKey(), String.valueOf(re.getValue()));
            }
            try {
                McpSchema.CallToolResult callToolResult;
                block13: {
                    Scope scope = span.makeCurrent();
                    try {
                        McpSchema.CallToolResult result = (McpSchema.CallToolResult)syncToolSpecification.call().apply(exchange, request);
                        span.setStatus(StatusCode.OK);
                        callToolResult = result;
                        if (scope == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (RuntimeException e) {
                            span.recordException((Throwable)e);
                            span.setStatus(StatusCode.ERROR);
                            throw e;
                        }
                    }
                    scope.close();
                }
                return callToolResult;
            }
            finally {
                if (this.durationConsumer != null) {
                    this.durationConsumer.accept("tool.sync." + syncToolSpecification.tool().name(), System.currentTimeMillis() - start);
                }
                span.end();
            }
        });
    }

    public McpServerFeatures.AsyncToolSpecification filter(McpServerFeatures.AsyncToolSpecification asyncToolSpecification) {
        return new McpServerFeatures.AsyncToolSpecification(asyncToolSpecification.tool(), (exchange, request) -> Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)Context.current());
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Async tool " + asyncToolSpecification.tool().name()).setAttribute("description", asyncToolSpecification.tool().description()).setParent(parentContext).startSpan();
            for (Map.Entry re : request.entrySet()) {
                span.setAttribute("request." + (String)re.getKey(), String.valueOf(re.getValue()));
            }
            try (Scope scope = span.makeCurrent();){
                Mono publisher = (Mono)asyncToolSpecification.call().apply(exchange, request);
                Mono mono = publisher.map(result -> {
                    span.setStatus(StatusCode.OK);
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)Context.current().with((ImplicitContextKeyed)span))).doFinally(signal -> {
                    if (this.durationConsumer != null) {
                        this.durationConsumer.accept("tool.sync." + asyncToolSpecification.tool().name(), System.currentTimeMillis() - start);
                    }
                    span.end();
                });
                return mono;
            }
        }));
    }

    public McpServerFeatures.SyncResourceSpecification filter(McpServerFeatures.SyncResourceSpecification syncResourceSpecification) {
        return new McpServerFeatures.SyncResourceSpecification(syncResourceSpecification.resource(), (exchange, request) -> {
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Sync resource " + syncResourceSpecification.resource().name()).setAttribute("description", syncResourceSpecification.resource().description()).setAttribute("resource-uri", syncResourceSpecification.resource().uri()).setAttribute("request-uri", request.uri()).setAttribute("mime-type", syncResourceSpecification.resource().mimeType()).startSpan();
            try {
                McpSchema.ReadResourceResult readResourceResult;
                block12: {
                    Scope scope = span.makeCurrent();
                    try {
                        McpSchema.ReadResourceResult result = (McpSchema.ReadResourceResult)syncResourceSpecification.readHandler().apply(exchange, request);
                        span.setStatus(StatusCode.OK);
                        readResourceResult = result;
                        if (scope == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (RuntimeException e) {
                            span.recordException((Throwable)e);
                            span.setStatus(StatusCode.ERROR);
                            throw e;
                        }
                    }
                    scope.close();
                }
                return readResourceResult;
            }
            finally {
                if (this.durationConsumer != null) {
                    this.durationConsumer.accept("tool.sync." + syncResourceSpecification.resource().name(), System.currentTimeMillis() - start);
                }
                span.end();
            }
        });
    }

    public McpServerFeatures.AsyncResourceSpecification filter(McpServerFeatures.AsyncResourceSpecification asyncResourceSpecification) {
        return new McpServerFeatures.AsyncResourceSpecification(asyncResourceSpecification.resource(), (exchange, request) -> Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)Context.current());
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Async resource " + asyncResourceSpecification.resource().name()).setAttribute("description", asyncResourceSpecification.resource().description()).setAttribute("resource-uri", asyncResourceSpecification.resource().uri()).setAttribute("request-uri", request.uri()).setAttribute("mime-type", asyncResourceSpecification.resource().mimeType()).setParent(parentContext).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono publisher = (Mono)asyncResourceSpecification.readHandler().apply(exchange, request);
                Mono mono = publisher.map(result -> {
                    span.setStatus(StatusCode.OK);
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)Context.current().with((ImplicitContextKeyed)span))).doFinally(signal -> {
                    if (this.durationConsumer != null) {
                        this.durationConsumer.accept("tool.sync." + asyncResourceSpecification.resource().name(), System.currentTimeMillis() - start);
                    }
                    span.end();
                });
                return mono;
            }
        }));
    }

    public McpServerFeatures.SyncPromptSpecification filter(McpServerFeatures.SyncPromptSpecification syncPromptSpecification) {
        return new McpServerFeatures.SyncPromptSpecification(syncPromptSpecification.prompt(), (exchange, request) -> {
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Sync prompt " + syncPromptSpecification.prompt().name()).setAttribute("description", syncPromptSpecification.prompt().description()).startSpan();
            try {
                McpSchema.GetPromptResult getPromptResult;
                block12: {
                    Scope scope = span.makeCurrent();
                    try {
                        McpSchema.GetPromptResult result = (McpSchema.GetPromptResult)syncPromptSpecification.promptHandler().apply(exchange, request);
                        span.setStatus(StatusCode.OK);
                        getPromptResult = result;
                        if (scope == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (RuntimeException e) {
                            span.recordException((Throwable)e);
                            span.setStatus(StatusCode.ERROR);
                            throw e;
                        }
                    }
                    scope.close();
                }
                return getPromptResult;
            }
            finally {
                if (this.durationConsumer != null) {
                    this.durationConsumer.accept("tool.sync." + syncPromptSpecification.prompt().name(), System.currentTimeMillis() - start);
                }
                span.end();
            }
        });
    }

    public McpServerFeatures.AsyncPromptSpecification filter(McpServerFeatures.AsyncPromptSpecification asyncPromptSpecification) {
        return new McpServerFeatures.AsyncPromptSpecification(asyncPromptSpecification.prompt(), (exchange, request) -> Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)Context.current());
            long start = System.currentTimeMillis();
            Span span = this.tracer.spanBuilder("Async prompt " + asyncPromptSpecification.prompt().name()).setAttribute("description", asyncPromptSpecification.prompt().description()).setParent(parentContext).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono publisher = (Mono)asyncPromptSpecification.promptHandler().apply(exchange, request);
                Mono mono = publisher.map(result -> {
                    span.setStatus(StatusCode.OK);
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)Context.current().with((ImplicitContextKeyed)span))).doFinally(signal -> {
                    if (this.durationConsumer != null) {
                        this.durationConsumer.accept("tool.sync." + asyncPromptSpecification.prompt().name(), System.currentTimeMillis() - start);
                    }
                    span.end();
                });
                return mono;
            }
        }));
    }
}

