/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.ai.mcp;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class TelemetryMcpClientTransportFilter
implements McpClientTransport {
    private McpClientTransport target;
    private Tracer tracer;
    private Context context;

    public TelemetryMcpClientTransportFilter(McpClientTransport target, Tracer tracer, Context context) {
        this.target = target;
        this.tracer = tracer;
        this.context = context;
    }

    public TelemetryMcpClientTransportFilter(McpClientTransport target, Tracer tracer) {
        this.target = target;
        this.tracer = tracer;
        this.context = Context.current();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Mono<Void> closeGracefully() {
        return Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)this.getContext());
            Span span = this.tracer.spanBuilder("closeGracefully").setSpanKind(SpanKind.CLIENT).setParent(parentContext).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono mono = this.target.closeGracefully().map(result -> {
                    span.setStatus(StatusCode.OK);
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)this.getContext().with((ImplicitContextKeyed)span))).doFinally(signal -> span.end());
                return mono;
            }
        });
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        return Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)this.getContext());
            Span span = this.tracer.spanBuilder("sendMessage").setSpanKind(SpanKind.CLIENT).setParent(parentContext).setAttribute("message", message.toString()).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono mono = this.target.sendMessage(message).map(result -> {
                    span.setStatus(StatusCode.OK);
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)this.getContext().with((ImplicitContextKeyed)span))).doFinally(signal -> span.end());
                return mono;
            }
        });
    }

    protected Context getContext() {
        return this.context == null ? Context.current() : this.context;
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.target.unmarshalFrom(data, typeRef);
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)this.getContext());
            Span span = this.tracer.spanBuilder("connect").setSpanKind(SpanKind.CLIENT).setParent(parentContext).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono mono = this.target.connect(this.filterHandler(handler)).doOnNext(result -> span.setStatus(StatusCode.OK)).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)this.getContext().with((ImplicitContextKeyed)span))).doFinally(signal -> span.end());
                return mono;
            }
        });
    }

    private Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> filterHandler(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return requestMono -> Mono.deferContextual(contextView -> {
            Context parentContext = (Context)contextView.getOrDefault(Context.class, (Object)this.getContext());
            Span span = this.tracer.spanBuilder("handle").setSpanKind(SpanKind.CLIENT).setParent(parentContext).startSpan();
            try (Scope scope = span.makeCurrent();){
                Mono mono = ((Mono)handler.apply((Mono<McpSchema.JSONRPCMessage>)requestMono)).map(result -> {
                    span.setStatus(StatusCode.OK);
                    span.setAttribute("response", result.toString());
                    return result;
                }).onErrorMap(error -> {
                    span.recordException(error);
                    span.setStatus(StatusCode.ERROR);
                    return error;
                }).contextWrite((ContextView)reactor.util.context.Context.of(Context.class, (Object)this.getContext().with((ImplicitContextKeyed)span))).doFinally(signal -> span.end());
                return mono;
            }
        });
    }
}

