/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import com.github.jelmerk.knn.Index;
import com.github.jelmerk.knn.Item;
import com.github.jelmerk.knn.SearchResult;
import com.github.jelmerk.knn.hnsw.HnswIndex;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.rag.core.Store;

public class IndexStore<K, V, D>
implements Store<K, V, D> {
    protected Index<V, K, IndexItem<V, K>, D> index;

    public IndexStore(Index<V, K, IndexItem<V, K>, D> index) {
        this.index = index;
    }

    public IndexStore(HnswIndex<V, K, IndexItem<V, K>, D> index, Iterable<Map.Entry<K, V>> entries, ProgressMonitor progressMonitor) {
        this((Index<V, K, IndexItem<V, K>, D>)index);
        if (entries != null) {
            entries.forEach(entry -> this.add(entry.getKey(), entry.getValue(), progressMonitor));
        }
    }

    protected IndexItem<V, K> createItem(K key, V value) {
        return new IndexItem<V, K>(value, key);
    }

    @Override
    public void add(K key, V value, ProgressMonitor progressMonitor) {
        this.index.add(this.createItem(key, value));
    }

    @Override
    public List<Store.SearchResult<V, D>> findNearest(K key, int limit) {
        return this.index.findNearest(key, limit).stream().map(sr -> {
            class SearchResultImpl
            implements Store.SearchResult<V, D> {
                SearchResult<IndexItem<V, K>, D> target;

                public SearchResultImpl(SearchResult<IndexItem<V, K>, D> sr) {
                    this.target = sr;
                }

                @Override
                public int compareTo(Store.SearchResult<V, D> o) {
                    return this.target.compareTo(((SearchResultImpl)o).target);
                }

                @Override
                public V getValue() {
                    return ((IndexItem)this.target.item()).id();
                }

                @Override
                public D getDistance() {
                    return this.target.distance();
                }
            }
            return new SearchResultImpl(sr);
        }).toList();
    }

    public static class IndexItem<V, K>
    implements Item<V, K> {
        private V value;
        private K key;
        int dimensions;

        public IndexItem(V value, K key) {
            this.value = value;
            this.key = key;
            this.dimensions = key.getClass().isArray() ? Array.getLength(key) : (key instanceof Collection ? ((Collection)key).size() : 1);
        }

        public V id() {
            return this.value;
        }

        public K vector() {
            return this.key;
        }

        public int dimensions() {
            return this.dimensions;
        }
    }
}

