/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.rag.core.KeyExtractor;

public interface Store<K, V, D> {
    public void add(K var1, V var2, ProgressMonitor var3);

    default public void add(V value, KeyExtractor<V, K> keyExtractor, ProgressMonitor progressMonitor) {
        this.add(keyExtractor.extract(value, progressMonitor), value, progressMonitor);
    }

    default public void addAll(Iterable<V> values, KeyExtractor<V, K> keyExtractor, ProgressMonitor progressMonitor) {
        this.addAll(StreamSupport.stream(values.spliterator(), false), keyExtractor, progressMonitor);
    }

    default public void addAll(Stream<V> values, KeyExtractor<V, K> keyExtractor, ProgressMonitor progressMonitor) {
        values.forEach(v -> this.add(v, keyExtractor, progressMonitor));
    }

    public List<SearchResult<V, D>> findNearest(K var1, int var2);

    default public <L, U, E> Store<L, U, E> adapt(final Function<L, K> keyEncoder, final Function<U, V> valueEncoder, final Function<V, U> valueDecoder, final Function<D, E> distanceDecoder) {
        return new Store<L, U, E>(){

            @Override
            public void add(L key, U value, ProgressMonitor progressMonitor) {
                Store.this.add(keyEncoder.apply(key), valueEncoder.apply(value), progressMonitor);
            }

            @Override
            public List<SearchResult<U, E>> findNearest(L key, int limit) {
                return Store.this.findNearest(keyEncoder.apply(key), limit).stream().map(sr -> new SearchResultAdapter(sr)).toList();
            }

            class SearchResultAdapter
            implements SearchResult<U, E> {
                private SearchResult<V, D> target;

                SearchResultAdapter(SearchResult<V, D> target) {
                    this.target = target;
                }

                @Override
                public int compareTo(SearchResult<U, E> o) {
                    if (o == this) {
                        return 0;
                    }
                    if (SearchResultAdapter.class.isInstance(o)) {
                        return this.target.compareTo(((SearchResultAdapter)o).target);
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public U getValue() {
                    return valueDecoder.apply(this.target.getValue());
                }

                @Override
                public E getDistance() {
                    return distanceDecoder.apply(this.target.getDistance());
                }
            }
        };
    }

    public static interface SearchResult<V, D>
    extends Comparable<SearchResult<V, D>> {
        public V getValue();

        public D getDistance();
    }
}

