/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.rag.core.KeyExtractor;
import org.nasdanika.rag.core.Store;

public abstract class AbstractEntryStore<K, V, D>
implements Store<K, V, D> {
    public abstract Collection<Map.Entry<K, V>> getEntries();

    protected abstract D distance(K var1, K var2);

    protected abstract int compareDistance(D var1, D var2);

    @Override
    public void add(K key, V value, ProgressMonitor progressMonitor) {
        this.getEntries().add(Map.entry(key, value));
    }

    protected boolean isParallelSearch(K key) {
        return true;
    }

    protected boolean isParallelAddAll() {
        return false;
    }

    @Override
    public void addAll(Iterable<V> values, KeyExtractor<V, K> keyExtractor, ProgressMonitor progressMonitor) {
        this.addAll(StreamSupport.stream(values.spliterator(), this.isParallelAddAll()), keyExtractor, progressMonitor);
    }

    @Override
    public List<Store.SearchResult<V, D>> findNearest(final K key, int limit) {
        Stream<Map.Entry<K, V>> entryStream = this.isParallelSearch(key) ? this.getEntries().parallelStream() : this.getEntries().stream();
        return entryStream.map(e -> {
            class SearchResultImpl
            implements Store.SearchResult<V, D> {
                D distance;
                V value;

                public SearchResultImpl(Map.Entry<K, V> entry) {
                    this.distance = this$0.distance(entry.getKey(), key);
                    this.value = entry.getValue();
                }

                @Override
                public int compareTo(Store.SearchResult<V, D> o) {
                    return this.compareDistance(this.distance, o.getDistance());
                }

                @Override
                public V getValue() {
                    return this.value;
                }

                @Override
                public D getDistance() {
                    return this.distance;
                }
            }
            return new SearchResultImpl(e);
        }).limit(limit).toList();
    }
}

