/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.nasdanika.rag.core.AbstractEntryStore;

public abstract class ZipEntryStore<D>
extends AbstractEntryStore<byte[], String, D> {
    public ZipEntryStore(ZipInputStream in) throws IOException {
        try (ZipInputStream zipInputStream = in;){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                this.loadEntry(in, entry);
            }
        }
    }

    protected void loadEntry(InputStream in, ZipEntry entry) throws IOException {
        if (!entry.isDirectory()) {
            ByteArrayOutputStream baos;
            try (ByteArrayOutputStream byteArrayOutputStream = baos = new ByteArrayOutputStream();){
                int b;
                while ((b = in.read()) != -1) {
                    baos.write(b);
                }
            }
            this.loadEntry(baos.toByteArray(), this.getValue(entry));
        }
    }

    public ZipEntryStore(ZipFile in) throws IOException {
        try (ZipFile zipFile = in;){
            Enumeration<? extends ZipEntry> entries = in.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.loadEntry(entry.isDirectory() ? null : in.getInputStream(entry), entry);
            }
        }
    }

    public ZipEntryStore() {
    }

    protected String getValue(ZipEntry entry) {
        return entry.getName();
    }

    protected ZipEntry createZipEntry(byte[] key, String value) {
        return new ZipEntry(value);
    }

    protected abstract void loadEntry(byte[] var1, String var2) throws IOException;

    public void save(ZipOutputStream out) throws IOException {
        try (ZipOutputStream zipOutputStream = out;){
            for (Map.Entry entry : this.getEntries()) {
                out.putNextEntry(this.createZipEntry((byte[])entry.getKey(), (String)entry.getValue()));
                out.write((byte[])entry.getKey());
                out.closeEntry();
            }
        }
    }
}

