/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.nasdanika.common.ProgressMonitor;

public interface KeyExtractor<V, K> {
    public K extract(V var1, ProgressMonitor var2);

    public static <V, K> KeyExtractor<V, K> from(Function<V, K> function) {
        return (value, progressMonitor) -> function.apply(value);
    }

    public static <V, K> KeyExtractor<V, K> from(BiFunction<V, ProgressMonitor, K> biFunction) {
        return biFunction::apply;
    }

    default public <L> KeyExtractor<V, L> then(Function<K, L> after) {
        return (value, progressMonitor) -> after.apply(this.extract(value, progressMonitor));
    }

    default public <L> KeyExtractor<V, L> then(BiFunction<K, ProgressMonitor, L> after) {
        return (value, progressMonitor) -> after.apply(this.extract(value, progressMonitor), progressMonitor);
    }

    default public <U> KeyExtractor<U, K> before(Function<U, V> before) {
        return (value, progressMonitor) -> this.extract(before.apply(value), progressMonitor);
    }

    default public <U> KeyExtractor<U, K> before(BiFunction<U, ProgressMonitor, V> before) {
        return (value, progressMonitor) -> this.extract(before.apply(value, progressMonitor), progressMonitor);
    }

    default public <T extends KeyExtractor<?, ?>> T adapt(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Cannot adapt " + this + " to " + type);
    }
}

