/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.rag.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.nasdanika.rag.core.ZipEntryStore;

public class ArrayListZipEntryStore
extends ZipEntryStore<Integer> {
    protected List<Map.Entry<byte[], String>> entries;

    public ArrayListZipEntryStore() {
    }

    public ArrayListZipEntryStore(ZipFile in) throws IOException {
        super(in);
    }

    public ArrayListZipEntryStore(ZipInputStream in) throws IOException {
        super(in);
    }

    @Override
    protected void loadEntry(byte[] key, String value) throws IOException {
        this.getEntries().add(Map.entry(key, value));
    }

    @Override
    public Collection<Map.Entry<byte[], String>> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Map.Entry<byte[], String>>();
        }
        return this.entries;
    }

    @Override
    protected Integer distance(byte[] a, byte[] b) {
        int ld = a.length - b.length;
        if (ld != 0) {
            return ld;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result += Math.abs(a[i] - b[i]);
        }
        return result;
    }

    @Override
    protected int compareDistance(Integer a, Integer b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        return a - b;
    }
}

