/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.gtfs.schedule;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import lombok.Generated;
import org.naviqore.gtfs.schedule.DataProvider;
import org.naviqore.gtfs.schedule.LocalProvider;
import org.naviqore.gtfs.schedule.RemoteProvider;

public enum GtfsScheduleDataset {
    SAMPLE_FEED_1(new LocalProvider("org/naviqore/gtfs/schedule/sample-feed-1.zip")),
    SWITZERLAND(new RemoteProvider("https://data.opentransportdata.swiss/dataset/timetable-2025-gtfs2020/permalink")),
    GERMANY(new RemoteProvider("https://download.gtfs.de/germany/free/latest.zip")),
    ZURICH_TRAMS(new RemoteProvider("https://connolly.ch/zuerich-trams.zip")),
    ZURICH(new RemoteProvider("https://connolly.ch/zvv.zip"));

    private final DataProvider provider;

    public File getZip(Path dir) throws IOException {
        return this.provider.getZip(dir, this.name().toLowerCase());
    }

    public File getUnzipped(Path dir) throws IOException {
        return this.provider.getUnzipped(dir, this.name().toLowerCase());
    }

    @Generated
    private GtfsScheduleDataset(DataProvider provider) {
        this.provider = provider;
    }
}

