/*
 * Decompiled with CFR 0.152.
 */
package org.naviqore.gtfs.schedule;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.naviqore.gtfs.schedule.DataProvider;
import org.naviqore.utils.network.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteProvider
implements DataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteProvider.class);
    private final String url;

    public RemoteProvider(String url) {
        this.url = url;
    }

    @Override
    public File getZip(Path dir, String name) throws IOException {
        log.info("Loading remote dataset: {}", (Object)this.url);
        Files.createDirectories(dir, new FileAttribute[0]);
        Path zipPath = dir.resolve(name + ".zip");
        if (!Files.exists(zipPath, new LinkOption[0])) {
            FileDownloader downloader = new FileDownloader(this.url);
            try {
                downloader.downloadTo(dir, zipPath.getFileName().toString(), false);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Download was interrupted", e);
            }
        } else {
            log.debug("Dataset already exists locally: {}", (Object)zipPath);
        }
        return zipPath.toFile();
    }
}

